/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.Kill;
import enterprises.orbital.evekit.model.common.KillAttacker;
import enterprises.orbital.evekit.model.common.KillItem;
import enterprises.orbital.evekit.model.common.KillVictim;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class KillSheetWriter {
    private KillSheetWriter() {
    }

    public static List<Long> dumpKillAttackers(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> kills, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("KillAttackers.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Kill ID", "Attacker Character ID", "Alliance ID", "Alliance Name", "Attacker Character Name", "Attacker Corporation ID", "Attacker Corporation Name", "Damage Done", "Faction ID", "Faction Name", "Security Status", "Ship Type ID", "Weapon Type ID", "Final Blow"});
        for (long killID : kills) {
            ArrayList allAttackers = new ArrayList();
            long contid = -1L;
            List batch = KillAttacker.getAllKillAttackers((SynchronizedEveAccount)acct, (long)at, (long)killID, (int)1000, (long)contid);
            while (batch.size() > 0) {
                allAttackers.addAll(batch);
                contid = ((KillAttacker)batch.get(batch.size() - 1)).getCid();
                batch = KillAttacker.getAllKillAttackers((SynchronizedEveAccount)acct, (long)at, (long)killID, (int)1000, (long)contid);
            }
            if (allAttackers.size() <= 0) continue;
            for (KillAttacker next : allAttackers) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getKillID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAttackerCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAllianceName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getAttackerCharacterName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getAttackerCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAttackerCorporationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getDamageDone(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getFactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getFactionName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getSecurityStatus(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getShipTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getWeaponTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isFinalBlow(), SheetUtils.CellFormat.NO_STYLE));
                if (!next.hasMetaData()) continue;
                itemIDs.add(next.getCid());
            }
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static List<Long> dumpKillItems(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> kills, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("KillItems.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Kill ID", "Type ID", "Flag", "Quantity Destroyed", "Quantity Dropped", "Singleton", "Container", "Sequence"});
        for (long killID : kills) {
            ArrayList allItems = new ArrayList();
            int contid = 0;
            List batch = KillItem.getAllKillItems((SynchronizedEveAccount)acct, (long)at, (long)killID, (int)1000, (int)contid);
            while (batch.size() > 0) {
                allItems.addAll(batch);
                contid = ((KillItem)batch.get(batch.size() - 1)).getSequence();
                batch = KillItem.getAllKillItems((SynchronizedEveAccount)acct, (long)at, (long)killID, (int)1000, (int)contid);
            }
            if (allItems.size() <= 0) continue;
            for (KillItem next : allItems) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getKillID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getFlag(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQtyDestroyed(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQtyDropped(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isSingleton(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getContainerSequence(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSequence(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                if (!next.hasMetaData()) continue;
                itemIDs.add(next.getCid());
            }
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static List<Long> dumpKillVictims(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> kills, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("KillVictims.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Kill ID", "Alliance ID", "Alliance Name", "Kill Character ID", "Kill Character Name", "Kill Corporation ID", "Kill Corporation Name", "Damage Taken", "Faction ID", "Faction Name", "Ship Type ID"});
        for (long killID : kills) {
            KillVictim victim = KillVictim.get((SynchronizedEveAccount)acct, (long)at, (long)killID);
            if (victim != null) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(victim.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(victim.getKillID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(victim.getAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(victim.getAllianceName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(victim.getKillCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(victim.getKillCharacterName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(victim.getKillCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(victim.getKillCorporationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(victim.getDamageTaken(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(victim.getFactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(victim.getFactionName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(victim.getShipTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                if (victim.hasMetaData()) {
                    itemIDs.add(victim.getCid());
                }
            }
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Kills.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Kill ID", "Kill Time (Raw)", "Kill Time", "Moon ID", "Solar System ID"});
        long contid = -1L;
        ArrayList<Long> killIDs = new ArrayList<Long>();
        List<Object> metaIDs = new ArrayList();
        List batch = Kill.getKillsForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (Object next : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getKillID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getKillTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getKillTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getMoonID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSolarSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                killIDs.add(next.getKillID());
                if (!next.hasMetaData()) continue;
                metaIDs.add(next.getCid());
            }
            contid = ((Kill)batch.get(batch.size() - 1)).getKillTime();
            batch = Kill.getKillsForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        if (killIDs.size() > 0) {
            int count;
            output = SheetUtils.prepForMetaData("KillsMeta.csv", stream, false, null);
            for (Object next : metaIDs) {
                count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "Kill");
                if (count <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            metaIDs = KillSheetWriter.dumpKillAttackers(acct, stream, killIDs, at);
            if (metaIDs.size() > 0) {
                output = SheetUtils.prepForMetaData("KillAttackersMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "KillAttacker");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            if ((metaIDs = KillSheetWriter.dumpKillItems(acct, stream, killIDs, at)).size() > 0) {
                output = SheetUtils.prepForMetaData("KillItemsMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "KillItem");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            if ((metaIDs = KillSheetWriter.dumpKillVictims(acct, stream, killIDs, at)).size() > 0) {
                output = SheetUtils.prepForMetaData("KillVictimsMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "KillVictim");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

