/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.FacWarStats;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class FacWarStatsSheetWriter {
    private FacWarStatsSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("FacWarStats.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Current Rank", "Enlisted (Raw)", "Enlisted", "Faction ID", "Faction Name", "Highest Rank", "Kills Last Week", "Kills Total", "Kills Yesterday", "Pilots", "Victory Points Last Week", "Victory Points Total", "Victory Points Yesterday"});
        FacWarStats stats = FacWarStats.get((SynchronizedEveAccount)acct, (long)at);
        if (stats != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(stats.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(stats.getCurrentRank(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getEnlisted(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(stats.getEnlisted()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(stats.getFactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getFactionName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(stats.getHighestRank(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getKillsLastWeek(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getKillsTotal(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getKillsYesterday(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getPilots(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getVictoryPointsLastWeek(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getVictoryPointsTotal(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(stats.getVictoryPointsYesterday(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("FacWarStatsMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, stats.getCid(), "FacWarStats");
        }
        output.flush();
        stream.closeEntry();
    }
}

