/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.ResearchAgent;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ResearchAgentSheetWriter {
    public static final Comparator<ResearchAgent> ascendingResearchAgentComparator = new Comparator<ResearchAgent>(){

        @Override
        public int compare(ResearchAgent o1, ResearchAgent o2) {
            if (o1.getAgentID() < o2.getAgentID()) {
                return -1;
            }
            if (o1.getAgentID() == o2.getAgentID()) {
                return 0;
            }
            return 1;
        }
    };

    private ResearchAgentSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("ResearchAgents.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Agent ID", "Current Points", "Points Per Day", "Remainder Points", "Research Start Date (Raw)", "Research Start Date", "Skill Type ID"});
        int contid = -1;
        List batch = ResearchAgent.getAllAgents((SynchronizedEveAccount)acct, (long)at, (int)1000, (int)contid);
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        while (batch.size() > 0) {
            for (ResearchAgent researchAgent : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(researchAgent.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(researchAgent.getAgentID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(researchAgent.getCurrentPoints(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(researchAgent.getPointsPerDay(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(researchAgent.getRemainderPoints(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(researchAgent.getResearchStartDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(researchAgent.getResearchStartDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(researchAgent.getSkillTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                metaIDs.add(researchAgent.getCid());
            }
            contid = ((ResearchAgent)batch.get(batch.size() - 1)).getAgentID();
            batch = ResearchAgent.getAllAgents((SynchronizedEveAccount)acct, (long)at, (int)1000, (int)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ResearchAgentsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "ResearchAgent");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

