/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.PlanetaryColony;
import enterprises.orbital.evekit.model.character.PlanetaryLink;
import enterprises.orbital.evekit.model.character.PlanetaryPin;
import enterprises.orbital.evekit.model.character.PlanetaryRoute;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class PlanetaryColoniesSheetWriter {
    private PlanetaryColoniesSheetWriter() {
    }

    public static List<Long> dumpPlanetaryPins(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> planets, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("PlanetaryPins.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Planet ID", "Pin ID", "Type ID", "Type Name", "Schematic ID", "Last Launch Time (Raw)", "Last Launch Time", "Cycle Time", "Quantity Per Cycle", "Install Time (Raw)", "Install Time", "Expiry Time (Raw)", "Expiry Time", "Content Type ID", "Content Type Name", "Content Quantity", "Longitude", "Latitude"});
        for (long planetID : planets) {
            List allPins = PlanetaryPin.getAllPlanetaryPinsByPlanet((SynchronizedEveAccount)acct, (long)at, (long)planetID);
            for (PlanetaryPin next : allPins) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getPinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getSchematicID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLastLaunchTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getLastLaunchTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getCycleTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQuantityPerCycle(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getInstallTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getInstallTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getExpiryTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getExpiryTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getContentTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContentTypeName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getContentQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLongitude(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getLatitude(), SheetUtils.CellFormat.DOUBLE_STYLE));
                if (!next.hasMetaData()) continue;
                itemIDs.add(next.getCid());
            }
            if (allPins.size() <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static List<Long> dumpPlanetaryLinks(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> planets, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("PlanetaryLinks.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Planet ID", "Source Pin ID", "Destination Pin ID", "Link Level"});
        for (long planetID : planets) {
            List allLinks = PlanetaryLink.getAllPlanetaryLinksByPlanet((SynchronizedEveAccount)acct, (long)at, (long)planetID);
            for (PlanetaryLink next : allLinks) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSourcePinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDestinationPinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLinkLevel(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                if (!next.hasMetaData()) continue;
                itemIDs.add(next.getCid());
            }
            if (allLinks.size() <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static List<Long> dumpPlanetaryRoutes(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> planets, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("PlanetaryRoutes.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Planet ID", "Route ID", "Source Pin ID", "Destination Pin ID", "Content Type ID", "Content Type Name", "Quantity", "Waypoint 1", "Waypoint 2", "Waypoint 3", "Waypoint 4", "Waypoint 5"});
        for (long planetID : planets) {
            List allRoutes = PlanetaryRoute.getAllPlanetaryRoutesByPlanet((SynchronizedEveAccount)acct, (long)at, (long)planetID);
            for (PlanetaryRoute next : allRoutes) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getRouteID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSourcePinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDestinationPinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContentTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContentTypeName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getWaypoint1(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getWaypoint2(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getWaypoint3(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getWaypoint4(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getWaypoint5(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                if (!next.hasMetaData()) continue;
                itemIDs.add(next.getCid());
            }
            if (allRoutes.size() <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("PlanetaryColonies.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Planet ID", "Solar System ID", "Solar System Name", "Planet Name", "Planet Type ID", "Planet Type Name", "Owner ID", "Owner Name", "Last Update (Raw)", "Last Update", "Upgrade Level", "Number Of Pins"});
        ArrayList<Long> planetIDs = new ArrayList<Long>();
        List<Object> metaIDs = new ArrayList();
        List batch = PlanetaryColony.getAllPlanetaryColonies((SynchronizedEveAccount)acct, (long)at);
        for (Object next : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSolarSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSolarSystemName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getPlanetTypeName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOwnerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOwnerName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getLastUpdate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getLastUpdate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getUpgradeLevel(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getNumberOfPins(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            planetIDs.add(next.getPlanetID());
            if (!next.hasMetaData()) continue;
            metaIDs.add(next.getCid());
        }
        output.flush();
        stream.closeEntry();
        if (planetIDs.size() > 0) {
            int count;
            output = SheetUtils.prepForMetaData("PlanetaryColoniesMeta.csv", stream, false, null);
            for (Object next : metaIDs) {
                count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "PlanetaryColony");
                if (count <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            metaIDs = PlanetaryColoniesSheetWriter.dumpPlanetaryPins(acct, stream, planetIDs, at);
            if (metaIDs.size() > 0) {
                output = SheetUtils.prepForMetaData("PlanetaryPinsMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "PlanetaryPin");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            if ((metaIDs = PlanetaryColoniesSheetWriter.dumpPlanetaryLinks(acct, stream, planetIDs, at)).size() > 0) {
                output = SheetUtils.prepForMetaData("PlanetaryLinksMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "PlanetaryLink");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            if ((metaIDs = PlanetaryColoniesSheetWriter.dumpPlanetaryRoutes(acct, stream, planetIDs, at)).size() > 0) {
                output = SheetUtils.prepForMetaData("PlanetaryRoutesMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "PlanetaryRoute");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

