/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterNotification;
import enterprises.orbital.evekit.model.character.CharacterNotificationBody;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class NotificationSheetWriter {
    private NotificationSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Notifications.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Notification ID", "Sender ID", "Type ID", "Sent Date (Raw)", "Sent Date", "Msg Read", "Text Retrieved", "Missing", "Text"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = CharacterNotification.getNotificationIDs((SynchronizedEveAccount)acct, (long)at, (boolean)false, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (Long next : batch) {
                CharacterNotification nextNote = CharacterNotification.get((SynchronizedEveAccount)acct, (long)at, (long)next);
                CharacterNotificationBody body = CharacterNotificationBody.get((SynchronizedEveAccount)acct, (long)at, (long)next);
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(nextNote.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextNote.getNotificationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextNote.getSenderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextNote.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextNote.getSentDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(nextNote.getSentDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(nextNote.isMsgRead(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(body.isRetrieved(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(body.isMissing(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(body.getText(), SheetUtils.CellFormat.NO_STYLE));
                metaIDs.add(nextNote.getCid());
                contid = nextNote.getSentDate();
            }
            batch = CharacterNotification.getNotificationIDs((SynchronizedEveAccount)acct, (long)at, (boolean)false, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("NotificationsMeta.csv", stream, false, null);
        for (Long next : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next, "CharacterNotification");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

