/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.ChatChannel;
import enterprises.orbital.evekit.model.character.ChatChannelMember;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ChatChannelSheetWriter {
    private ChatChannelSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("ChatChannels.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Channel ID", "Owner ID", "Owner Name", "Display Name", "Comparison Key", "Has Password", "MOTD"});
        List channels = ChatChannel.getAllChatChannels((SynchronizedEveAccount)acct, (long)at);
        for (ChatChannel next : channels) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getChannelID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOwnerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOwnerName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getDisplayName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getComparisonKey(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isHasPassword(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getMotd(), SheetUtils.CellFormat.NO_STYLE));
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ChatChannelsMeta.csv", stream, false, null);
        for (ChatChannel next : channels) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "ChatChannel");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
        stream.putNextEntry(new ZipEntry("ChatChannelMembers.csv"));
        output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Channel ID", "Category", "Accessor ID", "Accessor Name", "Until When (Raw)", "Until When", "Reason"});
        List members = ChatChannelMember.getAllChatChannelMembers((SynchronizedEveAccount)acct, (long)at);
        for (ChatChannelMember next : members) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getChannelID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getCategory(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getAccessorID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAccessorName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getUntilWhen(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getUntilWhen()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getReason(), SheetUtils.CellFormat.NO_STYLE));
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ChatChannelMembersMeta.csv", stream, false, null);
        for (ChatChannelMember next : members) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "ChatChannelMember");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

