/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterRole;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CapsuleerRoleSheetWriter {
    private CapsuleerRoleSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Roles.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Role ID", "Role Category", "Role Name"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List roles = CharacterRole.getAllRoles((SynchronizedEveAccount)acct, (long)at);
        for (CharacterRole characterRole : roles) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(characterRole.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterRole.getRoleID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterRole.getRoleCategory(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterRole.getRoleName(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(characterRole.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("RolesMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CharacterRole");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

