/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.Shareholder;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ShareholderSheetWriter {
    private ShareholderSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Shareholders.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Shareholder ID", "Corporation", "Shareholder Corporation ID", "Shareholder Corporation Name", "Shareholder Name", "Shares"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List batch = Shareholder.getAll((SynchronizedEveAccount)acct, (long)at);
        for (Shareholder shareholder : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(shareholder.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(shareholder.getShareholderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(shareholder.isCorporation(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(shareholder.getShareholderCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(shareholder.getShareholderCorporationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(shareholder.getShareholderName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(shareholder.getShares(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            metaIDs.add(shareholder.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ShareholdersMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "Shareholder");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

