/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.SecurityRole;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class SecurityRoleSheetWriter {
    private SecurityRoleSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("SecurityRoles.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Role ID", "Role Name"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List roles = SecurityRole.getAll((SynchronizedEveAccount)acct, (long)at);
        for (SecurityRole securityRole : roles) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(securityRole.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(securityRole.getRoleID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(securityRole.getRoleName(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(securityRole.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("SecurityRolesMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "SecurityRole");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

