/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.MemberSecurity;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MemberSecuritySheetWriter {
    private MemberSecuritySheetWriter() {
    }

    public static String setToString(Set<Long> convert) {
        return Arrays.toString((Object[])convert.toArray(new Long[convert.size()]));
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MemberSecurity.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Character ID", "Name", "Grantable Roles", "Grantable Roles At Base", "Grantable Roles At HQ", "Grantable Roles At Other", "Roles", "Roles At Base", "Roles At HQ", "Roles At Other", "Titles"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = MemberSecurity.getAll((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (MemberSecurity memberSecurity : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(memberSecurity.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberSecurity.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberSecurity.getName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getGrantableRoles()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getGrantableRolesAtBase()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getGrantableRolesAtHQ()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getGrantableRolesAtOther()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getRoles()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getRolesAtBase()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getRolesAtHQ()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getRolesAtOther()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecuritySheetWriter.setToString(memberSecurity.getTitles()), SheetUtils.CellFormat.NO_STYLE));
                metaIDs.add(memberSecurity.getCid());
            }
            contid = ((MemberSecurity)batch.get(batch.size() - 1)).getCharacterID();
            batch = MemberSecurity.getAll((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MemberSecurityMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "MemberSecurity");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

