/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.CorporationMemberMedal;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CorporationMemberMedalSheetWriter {
    private CorporationMemberMedalSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MemberMedals.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Medal ID", "Character ID", "Issued (Raw)", "Issued", "Issuer ID", "Reason", "Status"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = CorporationMemberMedal.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (CorporationMemberMedal corporationMemberMedal : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(corporationMemberMedal.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(corporationMemberMedal.getMedalID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(corporationMemberMedal.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(corporationMemberMedal.getIssued(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(corporationMemberMedal.getIssued()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(corporationMemberMedal.getIssuerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(corporationMemberMedal.getReason(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(corporationMemberMedal.getStatus(), SheetUtils.CellFormat.NO_STYLE));
                metaIDs.add(corporationMemberMedal.getCid());
            }
            contid = ((CorporationMemberMedal)batch.get(batch.size() - 1)).getIssued();
            batch = CorporationMemberMedal.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MemberMedalsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CorporationMemberMedal");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

