/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.MarketOrder;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MarketOrderSheetWriter {
    private MarketOrderSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MarketOrders.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Order ID", "Account Key", "Bid", "Character ID", "Duration", "Escrow", "Issued (Raw)", "Issued", "Min Volume", "Order State", "Price", "Order Range", "Station ID", "Type ID", "Volume Entered", "Volume Remaining"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = MarketOrder.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (MarketOrder marketOrder : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(marketOrder.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(marketOrder.getOrderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getAccountKey(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.isBid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(marketOrder.getCharID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getDuration(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getEscrow(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(marketOrder.getIssued(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(marketOrder.getIssued()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(marketOrder.getMinVolume(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getOrderState(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getPrice(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(marketOrder.getOrderRange(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getVolEntered(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(marketOrder.getVolRemaining(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                metaIDs.add(marketOrder.getCid());
            }
            contid = ((MarketOrder)batch.get(batch.size() - 1)).getIssued();
            batch = MarketOrder.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MarketOrdersMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "MarketOrder");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

