/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterSkillInTraining;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class SkillInTrainingSheetWriter {
    private SkillInTrainingSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("SkillInTraining.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Skill In Training", "Current Training Queue Time", "Training Start Time (Raw)", "Training Start Time", "Training End Time (Raw)", "Training End Time", "Training Start SP", "Training Destination SP", "Training To Level", "Skill Type ID"});
        CharacterSkillInTraining csheet = CharacterSkillInTraining.get((SynchronizedEveAccount)acct, (long)at);
        if (csheet != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(csheet.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.isSkillInTraining(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getCurrentTrainingQueueTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getTrainingStartTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getTrainingStartTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getTrainingEndTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getTrainingEndTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getTrainingStartSP(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getTrainingDestinationSP(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getTrainingToLevel(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("SkillInTrainingMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, csheet.getCid(), "CharacterSkillInTraining");
        }
        output.flush();
        stream.closeEntry();
    }
}

