/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterMedal;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MedalSheetWriter {
    private MedalSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Medals.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Medal ID", "Title", "Description", "Corporation ID", "Issued (Raw)", "Issued", "Issuer ID", "Reason", "Status"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List medals = CharacterMedal.getAllMedals((SynchronizedEveAccount)acct, (long)at);
        for (CharacterMedal characterMedal : medals) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(characterMedal.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterMedal.getMedalID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterMedal.getTitle(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterMedal.getDescription(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterMedal.getCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterMedal.getIssued(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(characterMedal.getIssued()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(characterMedal.getIssuerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterMedal.getReason(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterMedal.getStatus(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(characterMedal.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MedalsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CharacterMedal");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

