/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.MailingList;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MailingListSheetWriter {
    private MailingListSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MailingLists.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "List ID", "Display Name"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List lists = MailingList.getAllLists((SynchronizedEveAccount)acct, (long)at);
        for (MailingList mailingList : lists) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(mailingList.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(mailingList.getListID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(mailingList.getDisplayName(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(mailingList.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MailingListsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "MailingList");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

