/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterMailMessage;
import enterprises.orbital.evekit.model.character.CharacterMailMessageBody;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MailMessageSheetWriter {
    private MailMessageSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MailMessages.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Message ID", "Sender ID", "Sender Name", "ToCharacter IDs", "Sent Date (Raw)", "Sent Date", "Title", "ToCorpOrAlliance ID", "ToList IDs", "Msg Read", "SenderTypeID", "Body Retrieved", "Body"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = CharacterMailMessage.getMessageIDs((SynchronizedEveAccount)acct, (long)at, (boolean)false, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (Long next : batch) {
                CharacterMailMessage nextMsg = CharacterMailMessage.get((SynchronizedEveAccount)acct, (long)at, (long)next);
                CharacterMailMessageBody body = CharacterMailMessageBody.get((SynchronizedEveAccount)acct, (long)at, (long)next);
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(nextMsg.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextMsg.getMessageID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextMsg.getSenderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextMsg.getSenderName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(Arrays.toString((Object[])nextMsg.getToCharacterID().toArray(new Long[nextMsg.getToCharacterID().size()])), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextMsg.getSentDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(nextMsg.getSentDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(nextMsg.getTitle(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextMsg.getToCorpOrAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(Arrays.toString((Object[])nextMsg.getToListID().toArray(new Long[nextMsg.getToListID().size()])), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextMsg.isMsgRead(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextMsg.getSenderTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(body.isRetrieved(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(body.getBody(), SheetUtils.CellFormat.NO_STYLE));
                metaIDs.add(nextMsg.getCid());
                contid = nextMsg.getSentDate();
            }
            batch = CharacterMailMessage.getMessageIDs((SynchronizedEveAccount)acct, (long)at, (boolean)false, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MailMessagesMeta.csv", stream, false, null);
        for (Long next : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next, "CharacterMailMessage");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

