/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.MemberTracking;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MemberTrackingSheetWriter {
    private MemberTrackingSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MemberTracking.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Character ID", "Base", "Base ID", "Grantable Roles", "Location", "Location ID", "Logoff Date Time (Raw)", "Logoff Date Time", "Logon Date Time (Raw)", "Logon Date Time", "Name", "Roles", "Ship Type", "Ship Type ID", "Start Date Time (Raw)", "Start Date Time", "Title"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = MemberTracking.getAll((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (MemberTracking memberTracking : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(memberTracking.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberTracking.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getBase(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberTracking.getBaseID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getGrantableRoles(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getLocation(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberTracking.getLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getLogoffDateTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(memberTracking.getLogoffDateTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(memberTracking.getLogonDateTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(memberTracking.getLogonDateTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(memberTracking.getName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberTracking.getRoles(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getShipType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberTracking.getShipTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getStartDateTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(memberTracking.getStartDateTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(memberTracking.getTitle(), SheetUtils.CellFormat.NO_STYLE));
                metaIDs.add(memberTracking.getCid());
            }
            contid = ((MemberTracking)batch.get(batch.size() - 1)).getCharacterID();
            batch = MemberTracking.getAll((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MemberTrackingMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "MemberTracking");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

