/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.MemberSecurityLog;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MemberSecurityLogSheetWriter {
    private MemberSecurityLogSheetWriter() {
    }

    public static String setToString(Set<Long> convert) {
        return Arrays.toString((Object[])convert.toArray(new Long[convert.size()]));
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MemberSecurityLogs.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Change Time (Raw)", "Change Time", "Changed Character ID", "Changed Character Name", "Issuer ID", "Issuer Name", "Role Location Type", "Old Roles", "New Roles"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = MemberSecurityLog.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (MemberSecurityLog memberSecurityLog : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(memberSecurityLog.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberSecurityLog.getChangeTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(memberSecurityLog.getChangeTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(memberSecurityLog.getChangedCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberSecurityLog.getChangedCharacterName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberSecurityLog.getIssuerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberSecurityLog.getIssuerName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberSecurityLog.getRoleLocationType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecurityLogSheetWriter.setToString(memberSecurityLog.getOldRoles()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(MemberSecurityLogSheetWriter.setToString(memberSecurityLog.getNewRoles()), SheetUtils.CellFormat.NO_STYLE));
                metaIDs.add(memberSecurityLog.getCid());
            }
            contid = ((MemberSecurityLog)batch.get(batch.size() - 1)).getChangeTime();
            batch = MemberSecurityLog.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MemberSecurityLogsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "MemberSecurityLog");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

