/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.Facility;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class FacilitiesSheetWriter {
    private FacilitiesSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Facilities.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Facility ID", "Type ID", "Type Name", "Solar System ID", "Solar System Name", "Region ID", "Region Name", "Starbase Modifier", "Tax"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List facilities = Facility.getAll((SynchronizedEveAccount)acct, (long)at);
        for (Facility facility : facilities) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(facility.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(facility.getFacilityID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(facility.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(facility.getTypeName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(facility.getSolarSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(facility.getSolarSystemName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(facility.getRegionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(facility.getRegionName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(facility.getStarbaseModifier(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(facility.getTax(), SheetUtils.CellFormat.DOUBLE_STYLE));
            metaIDs.add(facility.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("FacilitiesMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "Facility");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

