/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.CorporationMedal;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CorporationMedalSheetWriter {
    private CorporationMedalSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CorporationMedals.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Medal ID", "Title", "Description", "Created (Raw)", "Created", "Creator ID"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List medals = CorporationMedal.getAll((SynchronizedEveAccount)acct, (long)at);
        for (CorporationMedal corporationMedal : medals) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(corporationMedal.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(corporationMedal.getMedalID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(corporationMedal.getTitle(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(corporationMedal.getDescription(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(corporationMedal.getCreated(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(corporationMedal.getCreated()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(corporationMedal.getCreatorID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            metaIDs.add(corporationMedal.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("CorporationMedalsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CorporationMedal");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

