/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.Division;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CorporationDivisionSheetWriter {
    private CorporationDivisionSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Divisions.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Account Key", "Description", "Wallet"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List batch = Division.getAllByType((SynchronizedEveAccount)acct, (long)at, (boolean)true);
        batch.addAll(Division.getAllByType((SynchronizedEveAccount)acct, (long)at, (boolean)false));
        for (Division division : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(division.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(division.getAccountKey(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(division.getDescription(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(division.isWallet(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(division.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("DivisionsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "Division");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

