/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.ContainerLog;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ContainerLogSheetWriter {
    private ContainerLogSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("ContainerLogs.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Log Time (Raw)", "Log Time", "Action", "Actor ID", "Actor Name", "Flag", "Item ID", "Item Type ID", "Location ID", "New Configuration", "Old Configuration", "Password Type", "Quantity", "Type ID"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = ContainerLog.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (ContainerLog containerLog : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(containerLog.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(containerLog.getLogTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(containerLog.getLogTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(containerLog.getAction(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(containerLog.getActorID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(containerLog.getActorName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(containerLog.getFlag(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(containerLog.getItemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(containerLog.getItemTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(containerLog.getLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(containerLog.getNewConfiguration(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(containerLog.getOldConfiguration(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(containerLog.getPasswordType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(containerLog.getQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(containerLog.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                metaIDs.add(containerLog.getCid());
            }
            contid = ((ContainerLog)batch.get(batch.size() - 1)).getLogTime();
            batch = ContainerLog.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ContainerLogsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "ContainerLog");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

