/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.WalletTransaction;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class WalletTransactionSheetWriter {
    private WalletTransactionSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("WalletTransactions.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Account Key", "Transaction ID", "Date (Raw)", "Date", "Quantity", "Type Name", "Type ID", "Price", "Client ID", "Client Name", "Station ID", "Station Name", "Transaction Type", "Transaction For", "Journal Transaction ID", "Client Type ID", "Character ID", "Character Name"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = WalletTransaction.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (WalletTransaction walletTransaction : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(walletTransaction.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletTransaction.getAccountKey(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getTransactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(walletTransaction.getDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(walletTransaction.getQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getTypeName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletTransaction.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getPrice(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(walletTransaction.getClientID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getClientName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletTransaction.getStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getStationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletTransaction.getTransactionType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletTransaction.getTransactionFor(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletTransaction.getJournalTransactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getClientTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletTransaction.getCharacterName(), SheetUtils.CellFormat.NO_STYLE));
                if (!walletTransaction.hasMetaData()) continue;
                metaIDs.add(walletTransaction.getCid());
            }
            contid = ((WalletTransaction)batch.get(batch.size() - 1)).getDate();
            batch = WalletTransaction.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("WalletTransactionsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "WalletTransaction");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

