/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.WalletJournal;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class WalletJournalSheetWriter {
    private WalletJournalSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("WalletJournal.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Account Key", "Ref ID", "Date (Raw)", "Date", "Ref Type ID", "Owner Name 1", "Owner ID 1", "Owner Name 2", "Owner ID 2", "Arg Name 1", "Arg ID 1", "Amount", "Balance", "Reason", "Tax Receiver ID", "Tax Amount", "Owner 1 Type ID", "Owner 2 Type ID"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = WalletJournal.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (WalletJournal walletJournal : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(walletJournal.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletJournal.getAccountKey(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletJournal.getRefID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletJournal.getDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(walletJournal.getDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(walletJournal.getRefTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletJournal.getOwnerName1(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletJournal.getOwnerID1(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletJournal.getOwnerName2(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletJournal.getOwnerID2(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletJournal.getArgName1(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletJournal.getArgID1(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletJournal.getAmount(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(walletJournal.getBalance(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(walletJournal.getReason(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(walletJournal.getTaxReceiverID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletJournal.getTaxAmount(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(walletJournal.getOwner1TypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(walletJournal.getOwner2TypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                if (!walletJournal.hasMetaData()) continue;
                metaIDs.add(walletJournal.getCid());
            }
            contid = ((WalletJournal)batch.get(batch.size() - 1)).getDate();
            batch = WalletJournal.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("WalletJournalMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "WalletJournal");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

