/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.IndustryJob;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class IndustryJobSheetWriter {
    private IndustryJobSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("IndustryJobs.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Job ID", "Installer ID", "Installer Name", "Facility ID", "Solar System ID", "Solar System Name", "Station ID", "Activity ID", "Blueprint ID", "Blueprint Type ID", "Blueprint Type Name", "Blueprint Location ID", "Output Location ID", "Runs", "Cost", "Team ID", "Licensed Runs", "Probability", "Product Type ID", "Product Type Name", "Status", "Time In Seconds", "Start Date (Raw)", "Start Date", "End Date (Raw)", "End Date", "Pause Date (Raw)", "Pause Date", "Completed Date (Raw)", "Completed Date", "Completed Character ID", "Successful Runs"});
        long contid = -1L;
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List batch = IndustryJob.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (IndustryJob industryJob : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(industryJob.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(industryJob.getJobID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getInstallerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getInstallerName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(industryJob.getFacilityID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getSolarSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getSolarSystemName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(industryJob.getStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getActivityID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getBlueprintID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getBlueprintTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getBlueprintTypeName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(industryJob.getBlueprintLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getOutputLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getRuns(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getCost(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(industryJob.getTeamID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getLicensedRuns(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getProbability(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(industryJob.getProductTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getProductTypeName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(industryJob.getStatus(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getTimeInSeconds(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getStartDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(industryJob.getStartDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(industryJob.getEndDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(industryJob.getEndDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(industryJob.getPauseDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(industryJob.getPauseDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(industryJob.getCompletedDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(industryJob.getCompletedDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(industryJob.getCompletedCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(industryJob.getSuccessfulRuns(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                metaIDs.add(industryJob.getCid());
            }
            contid = ((IndustryJob)batch.get(batch.size() - 1)).getStartDate();
            batch = IndustryJob.getAllForward((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("IndustryJobsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "IndustryJob");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

