/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.Contact;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ContactSheetWriter {
    private ContactSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Contacts.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "List", "Contact ID", "Contact Name", "Standing", "Contact Type ID", "In Watch List", "Label Mask"});
        ArrayList contacts = new ArrayList();
        long contid = -1L;
        List batch = Contact.getAllContacts((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            contacts.addAll(batch);
            contid = ((Contact)contacts.get(contacts.size() - 1)).getCid();
            batch = Contact.getAllContacts((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        for (Contact next : contacts) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getList(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getContactID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContactName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getStanding(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getContactTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isInWatchlist(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getLabelMask(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ContactsMeta.csv", stream, false, null);
        for (Contact next : contacts) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "Contact");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

