/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.AccountStatus;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class AccountStatusSheetWriter {
    private AccountStatusSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("AccountStatus.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Paid Until (Raw)", "Paid Until", "Create Date (Raw)", "Create Date", "Logon Count", "Logon Minutes", "MultiCharacterTraining (Raw)", "MultiCharacterTraining"});
        AccountStatus status = AccountStatus.get((SynchronizedEveAccount)acct, (long)at);
        if (status != null) {
            String rawTraining = Arrays.toString(status.getMultiCharacterTraining().toArray());
            StringBuilder trainingDates = new StringBuilder();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            trainingDates.append('[');
            Iterator iterator = status.getMultiCharacterTraining().iterator();
            while (iterator.hasNext()) {
                long nextDate = (Long)iterator.next();
                Date when = new Date(nextDate);
                trainingDates.append(formatter.format(when)).append(", ");
            }
            if (status.getMultiCharacterTraining().size() > 0) {
                trainingDates.setLength(trainingDates.length() - 2);
            }
            trainingDates.append(']');
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(status.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(status.getPaidUntil(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(status.getPaidUntil()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(status.getCreateDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(status.getCreateDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(status.getLogonCount(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(status.getLogonMinutes(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(rawTraining, SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(trainingDates.toString(), SheetUtils.CellFormat.NO_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("AccountStatusMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, status.getCid(), "AccountStatus");
        }
        output.flush();
        stream.closeEntry();
    }
}

