/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterSkill;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class SkillSheetWriter {
    private SkillSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Skills.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Type ID", "Level", "Skill Points", "Published"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        int contid = -1;
        List batch = CharacterSkill.getAll((SynchronizedEveAccount)acct, (long)at, (int)1000, (int)contid);
        while (batch.size() > 0) {
            for (CharacterSkill characterSkill : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(characterSkill.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterSkill.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterSkill.getLevel(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterSkill.getSkillpoints(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterSkill.isPublished(), SheetUtils.CellFormat.NO_STYLE));
                metaIDs.add(characterSkill.getCid());
            }
            contid = ((CharacterSkill)batch.get(batch.size() - 1)).getTypeID();
            batch = CharacterSkill.getAll((SynchronizedEveAccount)acct, (long)at, (int)1000, (int)contid);
        }
        output = SheetUtils.prepForMetaData("SkillsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CharacterSkill");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

