/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.JumpCloneImplant;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class JumpCloneImplantSheetWriter {
    private JumpCloneImplantSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("JumpCloneImplants.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Jump Clone ID", "Type ID", "Type Name"});
        List cloneImplants = JumpCloneImplant.getAll((SynchronizedEveAccount)acct, (long)at);
        for (JumpCloneImplant next : cloneImplants) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getJumpCloneID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeName(), SheetUtils.CellFormat.NO_STYLE));
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("JumpCloneImplantsMeta.csv", stream, false, null);
        for (JumpCloneImplant next : cloneImplants) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "JumpCloneImplant");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

