/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterContactNotification;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ContactNotificationSheetWriter {
    public static final Comparator<CharacterContactNotification> ascendingNotificationComparator = new Comparator<CharacterContactNotification>(){

        @Override
        public int compare(CharacterContactNotification o1, CharacterContactNotification o2) {
            if (o1.getSentDate() < o2.getSentDate()) {
                return -1;
            }
            if (o1.getSentDate() == o2.getSentDate()) {
                return 0;
            }
            return 1;
        }
    };

    private ContactNotificationSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("ContactNotifications.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Notification ID", "Sender ID", "SenderName", "Sent Date (Raw)", "Sent Date", "Message Data"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = CharacterContactNotification.getAllNotifications((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (CharacterContactNotification characterContactNotification : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(characterContactNotification.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterContactNotification.getNotificationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterContactNotification.getSenderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterContactNotification.getSenderName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterContactNotification.getSentDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(characterContactNotification.getSentDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(characterContactNotification.getMessageData(), SheetUtils.CellFormat.NO_STYLE));
                metaIDs.add(characterContactNotification.getCid());
            }
            contid = ((CharacterContactNotification)batch.get(batch.size() - 1)).getSentDate();
            batch = CharacterContactNotification.getAllNotifications((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ContactNotificationsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CharacterContactNotification");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

