/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterSheet;
import enterprises.orbital.evekit.model.character.CharacterSheetBalance;
import enterprises.orbital.evekit.model.character.CharacterSheetClone;
import enterprises.orbital.evekit.model.character.CharacterSheetJump;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CharacterSheetSheetWriter {
    private CharacterSheetSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CharacterSheet.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Balance", "Character ID", "Character Name", "Corporation ID", "Corporation Name", "Race", "DoB (Raw)", "DoB", "BloodlineID", "Bloodline", "AncestryID", "Ancestry", "Gender", "Alliance Name", "Alliance ID", "Faction Name", "Faction ID", "Clone Name", "Clone Skill Points", "Intelligence", "Memory", "Charisma", "Perception", "Willpower", "Home Station ID", "Clone Jump Date (Raw)", "Clone Jump Date", "Last Respec Date (Raw)", "Last Respec Date", "Last Timed Respec (Raw)", "Last Timed Respec", "Free Respecs", "Free Skill Points", "Clone Type ID", "Remote Station Date (Raw)", "Remote Station Date", "Jump Activation (Raw)", "Jump Activation", "Jump Fatigue (Raw)", "Jump Fatigue", "Jump Last Update (Raw)", "Jump Last Update"});
        CharacterSheet csheet = CharacterSheet.get((SynchronizedEveAccount)acct, (long)at);
        if (csheet != null) {
            CharacterSheetBalance bal = CharacterSheetBalance.get((SynchronizedEveAccount)acct, (long)at);
            CharacterSheetClone clone = CharacterSheetClone.get((SynchronizedEveAccount)acct, (long)at);
            CharacterSheetJump jump = CharacterSheetJump.get((SynchronizedEveAccount)acct, (long)at);
            BigDecimal balance = bal.getBalance();
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(csheet.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(balance, balance == null ? SheetUtils.CellFormat.NO_STYLE : SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(csheet.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getCorporationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getRace(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getDoB(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getDoB()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getBloodlineID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getBloodline(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getAncestryID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getAncestry(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getGender(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getAllianceName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getFactionName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getFactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getIntelligence(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getMemory(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getCharisma(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getPerception(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getWillpower(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getHomeStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(clone.getCloneJumpDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(clone.getCloneJumpDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getLastRespecDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getLastRespecDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getLastTimedRespec(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getLastTimedRespec()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getFreeRespecs(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getFreeSkillPoints(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getRemoteStationDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getRemoteStationDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(jump.getJumpActivation(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(jump.getJumpActivation()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(jump.getJumpFatigue(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(jump.getJumpFatigue()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(jump.getJumpLastUpdate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(jump.getJumpLastUpdate()), SheetUtils.CellFormat.DATE_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("CharacterSheetMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, csheet.getCid(), "CharacterSheet");
        }
        output.flush();
        stream.closeEntry();
    }
}

