/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.snapshot.capsuleer.CalendarSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.CapsuleerRoleSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.CharacterSheetSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.ChatChannelSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.ContactNotificationSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.ImplantSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.JumpCloneImplantSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.JumpCloneSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.MailMessageSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.MailingListSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.MedalSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.NotificationSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.PlanetaryColoniesSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.ResearchAgentSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.SkillInTrainingSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.SkillSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.SkillsInQueueSheetWriter;
import enterprises.orbital.evekit.snapshot.capsuleer.TitleSheetWriter;
import enterprises.orbital.evekit.snapshot.common.AccountBalanceSheetWriter;
import enterprises.orbital.evekit.snapshot.common.AccountStatusSheetWriter;
import enterprises.orbital.evekit.snapshot.common.AssetSheetWriter;
import enterprises.orbital.evekit.snapshot.common.BlueprintSheetWriter;
import enterprises.orbital.evekit.snapshot.common.BookmarkSheetWriter;
import enterprises.orbital.evekit.snapshot.common.ContactLabelSheetWriter;
import enterprises.orbital.evekit.snapshot.common.ContactSheetWriter;
import enterprises.orbital.evekit.snapshot.common.ContractSheetWriter;
import enterprises.orbital.evekit.snapshot.common.FacWarStatsSheetWriter;
import enterprises.orbital.evekit.snapshot.common.IndustryJobSheetWriter;
import enterprises.orbital.evekit.snapshot.common.KillSheetWriter;
import enterprises.orbital.evekit.snapshot.common.LocationSheetWriter;
import enterprises.orbital.evekit.snapshot.common.MarketOrderSheetWriter;
import enterprises.orbital.evekit.snapshot.common.StandingSheetWriter;
import enterprises.orbital.evekit.snapshot.common.WalletJournalSheetWriter;
import enterprises.orbital.evekit.snapshot.common.WalletTransactionSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.ContainerLogSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.CorporationDivisionSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.CorporationMedalSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.CorporationMemberMedalSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.CorporationRoleSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.CorporationSheetSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.CorporationTitleSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.CustomsOfficesSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.FacilitiesSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.MemberSecurityLogSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.MemberSecuritySheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.MemberTrackingSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.OutpostSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.SecurityRoleSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.SecurityTitleSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.ShareholderSheetWriter;
import enterprises.orbital.evekit.snapshot.corporation.StarbaseSheetWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;

public class SnapshotScheduler {
    protected static final Logger log = Logger.getLogger(SnapshotScheduler.class.getName());
    public static final String PROP_SNAPSHOT_DIR = "enterprises.orbital.evekit.snapshot.directory";
    public static final String DEF_SNAPSHOT_DIR = ".";

    public static String makeSnapshotFileNamePrefix(SynchronizedEveAccount acct) {
        return "snapshot_" + acct.getUserAccount().getUid() + "_" + acct.getAid() + "_";
    }

    public static String makeSnapshotFileName(SynchronizedEveAccount acct, Date when) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        return SnapshotScheduler.makeSnapshotFileNamePrefix(acct) + formatter.format(when) + ".zip";
    }

    public static List<File> findSnapshotFiles(SynchronizedEveAccount acct) throws IOException {
        ArrayList<File> eligible = new ArrayList<File>();
        final String prefix = SnapshotScheduler.makeSnapshotFileNamePrefix(acct);
        String snapshotDir = OrbitalProperties.getGlobalProperty((String)PROP_SNAPSHOT_DIR, (String)DEF_SNAPSHOT_DIR);
        File dir = new File(snapshotDir);
        eligible.addAll(Arrays.asList(dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }
        })));
        Collections.sort(eligible, new Comparator<File>(){
            final String formatString = "yyyy_MM_dd_HH_mm_ss";
            final SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");

            @Override
            public int compare(File arg0, File arg1) {
                try {
                    Date f1 = this.formatter.parse(arg0.getName().substring(prefix.length(), prefix.length() + "yyyy_MM_dd_HH_mm_ss".length()));
                    Date f2 = this.formatter.parse(arg1.getName().substring(prefix.length(), prefix.length() + "yyyy_MM_dd_HH_mm_ss".length()));
                    return f1.compareTo(f2);
                }
                catch (ParseException e) {
                    log.log(Level.WARNING, "Failed to compare snapshot file names: " + arg0 + " " + arg1, e);
                    return 0;
                }
            }
        });
        return eligible;
    }

    public static long lastSnapshotTime(SynchronizedEveAccount acct) throws IOException, ParseException {
        List<File> snapshots = SnapshotScheduler.findSnapshotFiles(acct);
        if (snapshots.size() > 0) {
            String prefix = SnapshotScheduler.makeSnapshotFileNamePrefix(acct);
            String formatString = "yyyy_MM_dd_HH_mm_ss";
            SimpleDateFormat formatter = new SimpleDateFormat(formatString);
            File last = snapshots.get(snapshots.size() - 1);
            Date when = formatter.parse(last.getName().substring(prefix.length(), prefix.length() + formatString.length()));
            return when.getTime();
        }
        return 0L;
    }

    public static void generateAccountSnapshot(SynchronizedEveAccount acct, long at) throws IOException {
        log.info("Generating snapshot for: " + acct);
        Date now = new Date(at);
        String filename = SnapshotScheduler.makeSnapshotFileName(acct, now);
        String snapshotDir = OrbitalProperties.getGlobalProperty((String)PROP_SNAPSHOT_DIR, (String)DEF_SNAPSHOT_DIR);
        ZipOutputStream writer = new ZipOutputStream(new FileOutputStream(snapshotDir + File.separator + filename));
        SnapshotScheduler.createAccountDump(acct, writer, at);
        writer.close();
        log.info("Snapshot complete: " + acct);
        List<File> oldFiles = SnapshotScheduler.findSnapshotFiles(acct);
        if (oldFiles.size() > 0) {
            oldFiles.remove(oldFiles.size() - 1);
        }
        for (File next : oldFiles) {
            if (next.delete()) continue;
            log.warning("Failed to delete eligible snapshot file: " + next);
        }
        log.info("Cleaned up " + oldFiles.size() + " files");
    }

    public static void createAccountDump(SynchronizedEveAccount toDump, ZipOutputStream writer, long at) throws IOException {
        if (toDump.isCharacterType()) {
            AccountStatusSheetWriter.dumpToSheet(toDump, writer, at);
        }
        AccountBalanceSheetWriter.dumpToSheet(toDump, writer, at);
        AssetSheetWriter.dumpToSheet(toDump, writer, at);
        BlueprintSheetWriter.dumpToSheet(toDump, writer, at);
        BookmarkSheetWriter.dumpToSheet(toDump, writer, at);
        ContactSheetWriter.dumpToSheet(toDump, writer, at);
        ContactLabelSheetWriter.dumpToSheet(toDump, writer, at);
        ContractSheetWriter.dumpToSheet(toDump, writer, at);
        FacWarStatsSheetWriter.dumpToSheet(toDump, writer, at);
        IndustryJobSheetWriter.dumpToSheet(toDump, writer, at);
        KillSheetWriter.dumpToSheet(toDump, writer, at);
        LocationSheetWriter.dumpToSheet(toDump, writer, at);
        MarketOrderSheetWriter.dumpToSheet(toDump, writer, at);
        StandingSheetWriter.dumpToSheet(toDump, writer, at);
        WalletJournalSheetWriter.dumpToSheet(toDump, writer, at);
        WalletTransactionSheetWriter.dumpToSheet(toDump, writer, at);
        if (toDump.isCharacterType()) {
            CalendarSheetWriter.dumpToSheet(toDump, writer, at);
            CharacterSheetSheetWriter.dumpToSheet(toDump, writer, at);
            ImplantSheetWriter.dumpToSheet(toDump, writer, at);
            JumpCloneSheetWriter.dumpToSheet(toDump, writer, at);
            JumpCloneImplantSheetWriter.dumpToSheet(toDump, writer, at);
            ChatChannelSheetWriter.dumpToSheet(toDump, writer, at);
            ContactNotificationSheetWriter.dumpToSheet(toDump, writer, at);
            MailingListSheetWriter.dumpToSheet(toDump, writer, at);
            MailMessageSheetWriter.dumpToSheet(toDump, writer, at);
            MedalSheetWriter.dumpToSheet(toDump, writer, at);
            NotificationSheetWriter.dumpToSheet(toDump, writer, at);
            PlanetaryColoniesSheetWriter.dumpToSheet(toDump, writer, at);
            ResearchAgentSheetWriter.dumpToSheet(toDump, writer, at);
            CapsuleerRoleSheetWriter.dumpToSheet(toDump, writer, at);
            SkillInTrainingSheetWriter.dumpToSheet(toDump, writer, at);
            SkillSheetWriter.dumpToSheet(toDump, writer, at);
            SkillsInQueueSheetWriter.dumpToSheet(toDump, writer, at);
            TitleSheetWriter.dumpToSheet(toDump, writer, at);
        } else {
            ContainerLogSheetWriter.dumpToSheet(toDump, writer, at);
            CorporationDivisionSheetWriter.dumpToSheet(toDump, writer, at);
            CorporationMedalSheetWriter.dumpToSheet(toDump, writer, at);
            CorporationMemberMedalSheetWriter.dumpToSheet(toDump, writer, at);
            CorporationSheetSheetWriter.dumpToSheet(toDump, writer, at);
            CorporationTitleSheetWriter.dumpToSheet(toDump, writer, at);
            CustomsOfficesSheetWriter.dumpToSheet(toDump, writer, at);
            FacilitiesSheetWriter.dumpToSheet(toDump, writer, at);
            MemberSecuritySheetWriter.dumpToSheet(toDump, writer, at);
            MemberSecurityLogSheetWriter.dumpToSheet(toDump, writer, at);
            MemberTrackingSheetWriter.dumpToSheet(toDump, writer, at);
            OutpostSheetWriter.dumpToSheet(toDump, writer, at);
            CorporationRoleSheetWriter.dumpToSheet(toDump, writer, at);
            SecurityRoleSheetWriter.dumpToSheet(toDump, writer, at);
            SecurityTitleSheetWriter.dumpToSheet(toDump, writer, at);
            ShareholderSheetWriter.dumpToSheet(toDump, writer, at);
            StarbaseSheetWriter.dumpToSheet(toDump, writer, at);
        }
    }
}

