/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.server.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.server.ServerStatus;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.svr.IServerAPI;
import enterprises.orbital.evexmlapi.svr.IServerStatus;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class ServerStatusSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(ServerStatusSync.class.getName());
    private static final ServerStatusSync syncher = new ServerStatusSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getServerStatusStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getServerStatusExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setServerStatusStatus(status);
        tracker.setServerStatusDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setServerStatusExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        assert (item instanceof ServerStatus);
        ServerStatus api = (ServerStatus)item;
        ServerStatus existing = ServerStatus.get((long)time);
        if (existing != null) {
            if (!existing.equivalent((RefCachedData)api)) {
                existing.evolve((RefCachedData)api, time);
                super.commit(time, tracker, container, (RefCachedData)existing);
                super.commit(time, tracker, container, (RefCachedData)api);
            }
        } else {
            api.setup(time);
            super.commit(time, tracker, container, (RefCachedData)api);
        }
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IServerAPI)serverRequest).requestServerStatus();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        IServerStatus status = (IServerStatus)data;
        updates.add((RefCachedData)new ServerStatus(status.getOnlinePlayers(), status.isServerOpen()));
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "ServerStatus");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "ServerStatus", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "ServerStatus", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

