/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.map.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.map.Sovereignty;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.map.IMapAPI;
import enterprises.orbital.evexmlapi.map.ISovereignty;
import enterprises.orbital.evexmlapi.map.ISystemSovereignty;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class SovereigntySync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(SovereigntySync.class.getName());
    private static final SovereigntySync syncher = new SovereigntySync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getSovereigntyStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getSovereigntyExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setSovereigntyStatus(status);
        tracker.setSovereigntyDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setSovereigntyExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof Sovereignty) {
            Sovereignty api = (Sovereignty)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                Sovereignty existing = Sovereignty.get((long)time, (int)api.getSolarSystemID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IMapAPI)serverRequest).requestSovereignty();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        ISovereignty sovList = (ISovereignty)data;
        HashSet<Integer> seenSov = new HashSet<Integer>();
        for (ISystemSovereignty nextSov : sovList.getSystemSovereignty()) {
            updates.add((RefCachedData)new Sovereignty(nextSov.getAllianceID(), nextSov.getCorporationID(), nextSov.getFactionID(), nextSov.getSolarSystemID(), nextSov.getSolarSystemName()));
            seenSov.add(nextSov.getSolarSystemID());
        }
        AttributeSelector ats = SovereigntySync.makeAtSelector(time);
        List nextBatch = Sovereignty.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextBatch.isEmpty()) {
            for (Sovereignty n : nextBatch) {
                if (seenSov.contains(n.getSolarSystemID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextBatch = Sovereignty.accessQuery((long)((Sovereignty)nextBatch.get(nextBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "Sovereignty");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "Sovereignty", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "Sovereignty", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

