/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.map.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.map.FactionWarSystem;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.map.IFacWarSystem;
import enterprises.orbital.evexmlapi.map.IMapAPI;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class FacWarSystemsSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(FacWarSystemsSync.class.getName());
    private static final FacWarSystemsSync syncher = new FacWarSystemsSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getFacWarSystemsStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getFacWarSystemsExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setFacWarSystemsStatus(status);
        tracker.setFacWarSystemsDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setFacWarSystemsExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof FactionWarSystem) {
            FactionWarSystem api = (FactionWarSystem)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                FactionWarSystem existing = FactionWarSystem.get((long)time, (int)api.getSolarSystemID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IMapAPI)serverRequest).requestFacWarSystems();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        Collection systemList = (Collection)data;
        HashSet<Integer> seenSystems = new HashSet<Integer>();
        for (IFacWarSystem nextSystem : systemList) {
            updates.add((RefCachedData)new FactionWarSystem(nextSystem.getOccupyingFactionID(), nextSystem.getOccupyingFactionName(), nextSystem.getOwningFactionID(), nextSystem.getOwningFactionName(), nextSystem.getSolarSystemID(), nextSystem.getSolarSystemName(), nextSystem.isContested()));
            seenSystems.add(nextSystem.getSolarSystemID());
        }
        AttributeSelector ats = FacWarSystemsSync.makeAtSelector(time);
        List nextBatch = FactionWarSystem.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextBatch.isEmpty()) {
            for (FactionWarSystem n : nextBatch) {
                if (seenSystems.contains(n.getSolarSystemID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextBatch = FactionWarSystem.accessQuery((long)((FactionWarSystem)nextBatch.get(nextBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "FacWarSystems");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "FacWarSystems", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "FacWarSystems", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

