/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.eve.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.eve.CharacterKillStat;
import enterprises.orbital.evekit.model.eve.CharacterVictoryPointStat;
import enterprises.orbital.evekit.model.eve.CorporationKillStat;
import enterprises.orbital.evekit.model.eve.CorporationVictoryPointStat;
import enterprises.orbital.evekit.model.eve.FactionKillStat;
import enterprises.orbital.evekit.model.eve.FactionVictoryPointStat;
import enterprises.orbital.evekit.model.eve.StatAttribute;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.eve.ICharacterKillStat;
import enterprises.orbital.evexmlapi.eve.ICharacterVictoryPointStat;
import enterprises.orbital.evexmlapi.eve.ICorporationKillStat;
import enterprises.orbital.evexmlapi.eve.ICorporationVictoryPointStat;
import enterprises.orbital.evexmlapi.eve.IEveAPI;
import enterprises.orbital.evexmlapi.eve.IFacWarTopStats;
import enterprises.orbital.evexmlapi.eve.IFacWarTopSummary;
import enterprises.orbital.evexmlapi.eve.IFactionKillStat;
import enterprises.orbital.evexmlapi.eve.IFactionVictoryPointStat;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class FacWarTopStatsSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(FacWarTopStatsSync.class.getName());
    private static final FacWarTopStatsSync syncher = new FacWarTopStatsSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getFacWarTopStatsStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getFacWarTopStatsExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setFacWarTopStatsStatus(status);
        tracker.setFacWarTopStatsDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setFacWarTopStatsExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof CharacterKillStat) {
            CharacterKillStat api = (CharacterKillStat)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                CharacterKillStat existing = CharacterKillStat.get((long)time, (StatAttribute)api.getAttribute(), (long)api.getCharacterID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof CharacterVictoryPointStat) {
            CharacterVictoryPointStat api = (CharacterVictoryPointStat)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                CharacterVictoryPointStat existing = CharacterVictoryPointStat.get((long)time, (StatAttribute)api.getAttribute(), (long)api.getCharacterID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof CorporationKillStat) {
            CorporationKillStat api = (CorporationKillStat)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                CorporationKillStat existing = CorporationKillStat.get((long)time, (StatAttribute)api.getAttribute(), (long)api.getCorporationID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof CorporationVictoryPointStat) {
            CorporationVictoryPointStat api = (CorporationVictoryPointStat)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                CorporationVictoryPointStat existing = CorporationVictoryPointStat.get((long)time, (StatAttribute)api.getAttribute(), (long)api.getCorporationID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof FactionKillStat) {
            FactionKillStat api = (FactionKillStat)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                FactionKillStat existing = FactionKillStat.get((long)time, (StatAttribute)api.getAttribute(), (long)api.getFactionID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof FactionVictoryPointStat) {
            FactionVictoryPointStat api = (FactionVictoryPointStat)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                FactionVictoryPointStat existing = FactionVictoryPointStat.get((long)time, (StatAttribute)api.getAttribute(), (long)api.getFactionID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IEveAPI)serverRequest).requestFacWarTopStats();
    }

    private <A extends RefCachedData, B> void populateStat(long time, StatAttribute attr, Collection<B> data, List<RefCachedData> updates, StatCreator<A, B> ctor, GetExistingData<A> setRetriever, GetItemID<A> getID) {
        HashSet<Long> seen = new HashSet<Long>();
        for (B nextStat : data) {
            updates.add((RefCachedData)ctor.createStat(attr, nextStat, seen));
        }
        List<A> nextBatch = setRetriever.getNextSet(attr, Collections.emptyList());
        while (!nextBatch.isEmpty()) {
            for (RefCachedData n : nextBatch) {
                if (seen.contains(getID.getID(n))) continue;
                n.evolve(null, time);
                updates.add(n);
            }
            nextBatch = setRetriever.getNextSet(attr, nextBatch);
        }
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        final AttributeSelector ats = FacWarTopStatsSync.makeAtSelector(time);
        IFacWarTopSummary summary = (IFacWarTopSummary)data;
        IFacWarTopStats charStats = summary.getCharacterStats();
        StatCreator<CharacterKillStat, ICharacterKillStat> charKillCreator = new StatCreator<CharacterKillStat, ICharacterKillStat>(){

            @Override
            public CharacterKillStat createStat(StatAttribute attr, ICharacterKillStat source, Set<Long> seenSet) {
                seenSet.add(source.getCharacterID());
                return new CharacterKillStat(attr, source.getKills(), source.getCharacterID(), source.getCharacterName());
            }
        };
        GetItemID<CharacterKillStat> charKillIDGet = new GetItemID<CharacterKillStat>(){

            @Override
            public long getID(CharacterKillStat item) {
                return item.getCharacterID();
            }
        };
        GetExistingData<CharacterKillStat> charKillGetExisting = new GetExistingData<CharacterKillStat>(){

            @Override
            public List<CharacterKillStat> getNextSet(StatAttribute attr, List<CharacterKillStat> previousSet) {
                long contid = previousSet.isEmpty() ? -1L : previousSet.get(previousSet.size() - 1).getCid();
                return CharacterKillStat.accessQuery((long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)new AttributeSelector("{values: ['" + attr.toString() + "']}"), (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
            }
        };
        this.populateStat(time, StatAttribute.LAST_WEEK, charStats.getKillsLastWeek(), updates, charKillCreator, charKillGetExisting, charKillIDGet);
        this.populateStat(time, StatAttribute.TOTAL, charStats.getKillsTotal(), updates, charKillCreator, charKillGetExisting, charKillIDGet);
        this.populateStat(time, StatAttribute.YESTERDAY, charStats.getKillsYesterday(), updates, charKillCreator, charKillGetExisting, charKillIDGet);
        StatCreator<CharacterVictoryPointStat, ICharacterVictoryPointStat> charVPCreator = new StatCreator<CharacterVictoryPointStat, ICharacterVictoryPointStat>(){

            @Override
            public CharacterVictoryPointStat createStat(StatAttribute attr, ICharacterVictoryPointStat source, Set<Long> seenSet) {
                seenSet.add(source.getCharacterID());
                return new CharacterVictoryPointStat(attr, source.getVictoryPoints(), source.getCharacterID(), source.getCharacterName());
            }
        };
        GetItemID<CharacterVictoryPointStat> charVPIDGet = new GetItemID<CharacterVictoryPointStat>(){

            @Override
            public long getID(CharacterVictoryPointStat item) {
                return item.getCharacterID();
            }
        };
        GetExistingData<CharacterVictoryPointStat> charVPGetExisting = new GetExistingData<CharacterVictoryPointStat>(){

            @Override
            public List<CharacterVictoryPointStat> getNextSet(StatAttribute attr, List<CharacterVictoryPointStat> previousSet) {
                long contid = previousSet.isEmpty() ? -1L : previousSet.get(previousSet.size() - 1).getCid();
                return CharacterVictoryPointStat.accessQuery((long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)new AttributeSelector("{values: ['" + attr.toString() + "']}"), (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
            }
        };
        this.populateStat(time, StatAttribute.LAST_WEEK, charStats.getVictoryPointsLastWeek(), updates, charVPCreator, charVPGetExisting, charVPIDGet);
        this.populateStat(time, StatAttribute.TOTAL, charStats.getVictoryPointsTotal(), updates, charVPCreator, charVPGetExisting, charVPIDGet);
        this.populateStat(time, StatAttribute.YESTERDAY, charStats.getVictoryPointsYesterday(), updates, charVPCreator, charVPGetExisting, charVPIDGet);
        IFacWarTopStats corpStats = summary.getCorporationStats();
        StatCreator<CorporationKillStat, ICorporationKillStat> corpKillCreator = new StatCreator<CorporationKillStat, ICorporationKillStat>(){

            @Override
            public CorporationKillStat createStat(StatAttribute attr, ICorporationKillStat source, Set<Long> seenSet) {
                seenSet.add(source.getCorporationID());
                return new CorporationKillStat(attr, source.getKills(), source.getCorporationID(), source.getCorporationName());
            }
        };
        GetItemID<CorporationKillStat> corpKillIDGet = new GetItemID<CorporationKillStat>(){

            @Override
            public long getID(CorporationKillStat item) {
                return item.getCorporationID();
            }
        };
        GetExistingData<CorporationKillStat> corpKillGetExisting = new GetExistingData<CorporationKillStat>(){

            @Override
            public List<CorporationKillStat> getNextSet(StatAttribute attr, List<CorporationKillStat> previousSet) {
                long contid = previousSet.isEmpty() ? -1L : previousSet.get(previousSet.size() - 1).getCid();
                return CorporationKillStat.accessQuery((long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)new AttributeSelector("{values: ['" + attr.toString() + "']}"), (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
            }
        };
        this.populateStat(time, StatAttribute.LAST_WEEK, corpStats.getKillsLastWeek(), updates, corpKillCreator, corpKillGetExisting, corpKillIDGet);
        this.populateStat(time, StatAttribute.TOTAL, corpStats.getKillsTotal(), updates, corpKillCreator, corpKillGetExisting, corpKillIDGet);
        this.populateStat(time, StatAttribute.YESTERDAY, corpStats.getKillsYesterday(), updates, corpKillCreator, corpKillGetExisting, corpKillIDGet);
        StatCreator<CorporationVictoryPointStat, ICorporationVictoryPointStat> corpVPCreator = new StatCreator<CorporationVictoryPointStat, ICorporationVictoryPointStat>(){

            @Override
            public CorporationVictoryPointStat createStat(StatAttribute attr, ICorporationVictoryPointStat source, Set<Long> seenSet) {
                seenSet.add(source.getCorporationID());
                return new CorporationVictoryPointStat(attr, source.getVictoryPoints(), source.getCorporationID(), source.getCorporationName());
            }
        };
        GetItemID<CorporationVictoryPointStat> corpVPIDGet = new GetItemID<CorporationVictoryPointStat>(){

            @Override
            public long getID(CorporationVictoryPointStat item) {
                return item.getCorporationID();
            }
        };
        GetExistingData<CorporationVictoryPointStat> corpVPGetExisting = new GetExistingData<CorporationVictoryPointStat>(){

            @Override
            public List<CorporationVictoryPointStat> getNextSet(StatAttribute attr, List<CorporationVictoryPointStat> previousSet) {
                long contid = previousSet.isEmpty() ? -1L : previousSet.get(previousSet.size() - 1).getCid();
                return CorporationVictoryPointStat.accessQuery((long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)new AttributeSelector("{values: ['" + attr.toString() + "']}"), (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
            }
        };
        this.populateStat(time, StatAttribute.LAST_WEEK, corpStats.getVictoryPointsLastWeek(), updates, corpVPCreator, corpVPGetExisting, corpVPIDGet);
        this.populateStat(time, StatAttribute.TOTAL, corpStats.getVictoryPointsTotal(), updates, corpVPCreator, corpVPGetExisting, corpVPIDGet);
        this.populateStat(time, StatAttribute.YESTERDAY, corpStats.getVictoryPointsYesterday(), updates, corpVPCreator, corpVPGetExisting, corpVPIDGet);
        IFacWarTopStats factionStats = summary.getFactionStats();
        StatCreator<FactionKillStat, IFactionKillStat> factionKillCreator = new StatCreator<FactionKillStat, IFactionKillStat>(){

            @Override
            public FactionKillStat createStat(StatAttribute attr, IFactionKillStat source, Set<Long> seenSet) {
                seenSet.add(source.getFactionID());
                return new FactionKillStat(attr, source.getKills(), source.getFactionID(), source.getFactionName());
            }
        };
        GetItemID<FactionKillStat> factionKillIDGet = new GetItemID<FactionKillStat>(){

            @Override
            public long getID(FactionKillStat item) {
                return item.getFactionID();
            }
        };
        GetExistingData<FactionKillStat> factionKillGetExisting = new GetExistingData<FactionKillStat>(){

            @Override
            public List<FactionKillStat> getNextSet(StatAttribute attr, List<FactionKillStat> previousSet) {
                long contid = previousSet.isEmpty() ? -1L : previousSet.get(previousSet.size() - 1).getCid();
                return FactionKillStat.accessQuery((long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)new AttributeSelector("{values: ['" + attr.toString() + "']}"), (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
            }
        };
        this.populateStat(time, StatAttribute.LAST_WEEK, factionStats.getKillsLastWeek(), updates, factionKillCreator, factionKillGetExisting, factionKillIDGet);
        this.populateStat(time, StatAttribute.TOTAL, factionStats.getKillsTotal(), updates, factionKillCreator, factionKillGetExisting, factionKillIDGet);
        this.populateStat(time, StatAttribute.YESTERDAY, factionStats.getKillsYesterday(), updates, factionKillCreator, factionKillGetExisting, factionKillIDGet);
        StatCreator<FactionVictoryPointStat, IFactionVictoryPointStat> factionVPCreator = new StatCreator<FactionVictoryPointStat, IFactionVictoryPointStat>(){

            @Override
            public FactionVictoryPointStat createStat(StatAttribute attr, IFactionVictoryPointStat source, Set<Long> seenSet) {
                seenSet.add(source.getFactionID());
                return new FactionVictoryPointStat(attr, source.getVictoryPoints(), source.getFactionID(), source.getFactionName());
            }
        };
        GetItemID<FactionVictoryPointStat> factionVPIDGet = new GetItemID<FactionVictoryPointStat>(){

            @Override
            public long getID(FactionVictoryPointStat item) {
                return item.getFactionID();
            }
        };
        GetExistingData<FactionVictoryPointStat> factionVPGetExisting = new GetExistingData<FactionVictoryPointStat>(){

            @Override
            public List<FactionVictoryPointStat> getNextSet(StatAttribute attr, List<FactionVictoryPointStat> previousSet) {
                long contid = previousSet.isEmpty() ? -1L : previousSet.get(previousSet.size() - 1).getCid();
                return FactionVictoryPointStat.accessQuery((long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)new AttributeSelector("{values: ['" + attr.toString() + "']}"), (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
            }
        };
        this.populateStat(time, StatAttribute.LAST_WEEK, factionStats.getVictoryPointsLastWeek(), updates, factionVPCreator, factionVPGetExisting, factionVPIDGet);
        this.populateStat(time, StatAttribute.TOTAL, factionStats.getVictoryPointsTotal(), updates, factionVPCreator, factionVPGetExisting, factionVPIDGet);
        this.populateStat(time, StatAttribute.YESTERDAY, factionStats.getVictoryPointsYesterday(), updates, factionVPCreator, factionVPGetExisting, factionVPIDGet);
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "FacWarTopStats");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "FacWarTopStats", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "FacWarTopStats", SyncTracker.SyncState.NOT_ALLOWED);
    }

    private static interface GetItemID<A extends RefCachedData> {
        public long getID(A var1);
    }

    private static interface GetExistingData<A extends RefCachedData> {
        public List<A> getNextSet(StatAttribute var1, List<A> var2);
    }

    private static interface StatCreator<A extends RefCachedData, B> {
        public A createStat(StatAttribute var1, B var2, Set<Long> var3);
    }
}

