/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.eve.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.eve.FactionStats;
import enterprises.orbital.evekit.model.eve.FactionWar;
import enterprises.orbital.evekit.model.eve.FactionWarSummary;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.eve.IEveAPI;
import enterprises.orbital.evexmlapi.eve.IFacWarSummary;
import enterprises.orbital.evexmlapi.eve.IFactionStats;
import enterprises.orbital.evexmlapi.eve.IFactionWar;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class FacWarStatsSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(FacWarStatsSync.class.getName());
    private static final FacWarStatsSync syncher = new FacWarStatsSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getFacWarStatsStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getFacWarStatsExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setFacWarStatsStatus(status);
        tracker.setFacWarStatsDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setFacWarStatsExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof FactionWarSummary) {
            FactionWarSummary api = (FactionWarSummary)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                FactionWarSummary existing = FactionWarSummary.get((long)time);
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof FactionStats) {
            FactionStats api = (FactionStats)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                FactionStats existing = FactionStats.get((long)time, (long)api.getFactionID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof FactionWar) {
            FactionWar api = (FactionWar)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                FactionWar existing = FactionWar.get((long)time, (long)api.getAgainstID(), (long)api.getFactionID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IEveAPI)serverRequest).requestFacWarStats();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        IFacWarSummary summary = (IFacWarSummary)data;
        updates.add((RefCachedData)new FactionWarSummary(summary.getKillsLastWeek(), summary.getKillsTotal(), summary.getKillsYesterday(), summary.getVictoryPointsLastWeek(), summary.getVictoryPointsTotal(), summary.getVictoryPointsYesterday()));
        Collection factionList = summary.getFactions();
        HashSet<Long> seenFactions = new HashSet<Long>();
        for (IFactionStats nextAlliance : factionList) {
            updates.add((RefCachedData)new FactionStats(nextAlliance.getFactionID(), nextAlliance.getFactionName(), nextAlliance.getKillsLastWeek(), nextAlliance.getKillsTotal(), nextAlliance.getKillsYesterday(), nextAlliance.getPilots(), nextAlliance.getSystemsControlled(), nextAlliance.getVictoryPointsLastWeek(), nextAlliance.getVictoryPointsTotal(), nextAlliance.getVictoryPointsYesterday()));
            seenFactions.add(nextAlliance.getFactionID());
        }
        AttributeSelector ats = FacWarStatsSync.makeAtSelector(time);
        List nextBatch = FactionStats.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextBatch.isEmpty()) {
            for (FactionStats n : nextBatch) {
                if (seenFactions.contains(n.getFactionID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextBatch = FactionStats.accessQuery((long)((FactionStats)nextBatch.get(nextBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        HashMap seenWars = new HashMap();
        for (IFactionWar nextWar : summary.getWars()) {
            updates.add((RefCachedData)new FactionWar(nextWar.getAgainstID(), nextWar.getAgainstName(), nextWar.getFactionID(), nextWar.getFactionName()));
            if (!seenWars.containsKey(nextWar.getAgainstID())) {
                seenWars.put(nextWar.getAgainstID(), new HashSet());
            }
            ((Set)seenWars.get(nextWar.getAgainstID())).add(nextWar.getFactionID());
        }
        List nextWarBatch = FactionWar.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextWarBatch.isEmpty()) {
            for (FactionWar n : nextWarBatch) {
                if (seenWars.containsKey(n.getAgainstID()) && ((Set)seenWars.get(n.getAgainstID())).contains(n.getFactionID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextWarBatch = FactionWar.accessQuery((long)((FactionWar)nextWarBatch.get(nextWarBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "FacWarStats");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "FacWarStats", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "FacWarStats", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

