/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.eve.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.eve.Alliance;
import enterprises.orbital.evekit.model.eve.AllianceMemberCorporation;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.eve.IAlliance;
import enterprises.orbital.evexmlapi.eve.IEveAPI;
import enterprises.orbital.evexmlapi.eve.IMemberCorporation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class AllianceSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(AllianceSync.class.getName());
    private static final AllianceSync syncher = new AllianceSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getAllianceListStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getAllianceListExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setAllianceListStatus(status);
        tracker.setAllianceListDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setAllianceListExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof Alliance) {
            Alliance api = (Alliance)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                Alliance existing = Alliance.get((long)time, (long)api.getAllianceID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof AllianceMemberCorporation) {
            AllianceMemberCorporation api = (AllianceMemberCorporation)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                AllianceMemberCorporation existing = AllianceMemberCorporation.get((long)time, (long)api.getAllianceID(), (long)api.getCorporationID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IEveAPI)serverRequest).requestAlliances();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        Collection allianceList = (Collection)data;
        HashSet<Long> seenAlliances = new HashSet<Long>();
        for (IAlliance nextAlliance : allianceList) {
            updates.add((RefCachedData)new Alliance(nextAlliance.getAllianceID(), nextAlliance.getExecutorCorpID(), nextAlliance.getMemberCount(), nextAlliance.getName(), nextAlliance.getShortName(), nextAlliance.getStartDate().getTime()));
            seenAlliances.add(nextAlliance.getAllianceID());
        }
        AttributeSelector ats = AllianceSync.makeAtSelector(time);
        List nextBatch = Alliance.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextBatch.isEmpty()) {
            for (Alliance n : nextBatch) {
                if (seenAlliances.contains(n.getAllianceID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextBatch = Alliance.accessQuery((long)((Alliance)nextBatch.get(nextBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        HashMap seenMembers = new HashMap();
        for (IAlliance nextAlliance : allianceList) {
            for (IMemberCorporation nextCorp : nextAlliance.getMemberCorporations()) {
                updates.add((RefCachedData)new AllianceMemberCorporation(nextAlliance.getAllianceID(), nextCorp.getCorporationID(), nextCorp.getStartDate().getTime()));
                if (!seenMembers.containsKey(nextAlliance.getAllianceID())) {
                    seenMembers.put(nextAlliance.getAllianceID(), new HashSet());
                }
                ((Set)seenMembers.get(nextAlliance.getAllianceID())).add(nextCorp.getCorporationID());
            }
        }
        List nextCorpBatch = AllianceMemberCorporation.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextCorpBatch.isEmpty()) {
            for (AllianceMemberCorporation n : nextCorpBatch) {
                if (seenMembers.containsKey(n.getAllianceID()) && ((Set)seenMembers.get(n.getAllianceID())).contains(n.getCorporationID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextCorpBatch = AllianceMemberCorporation.accessQuery((long)((AllianceMemberCorporation)nextCorpBatch.get(nextCorpBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "AllianceList");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "AllianceList", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "AllianceList", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

