/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.ModelUtil;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizationHandler;
import enterprises.orbital.evekit.model.SyncTracker;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RefSynchronizerUtil {
    protected static final Logger log = Logger.getLogger(RefSynchronizerUtil.class.getName());
    public static final int COMMIT_BATCH_SIZE = 200;

    public SynchOutcome checkProceedWithSynch(String msgInfo, RefSynchronizationHandler handler) throws IOException {
        String context = "[refData]";
        SynchOutcome result = SynchOutcome.COMPLETE;
        RefSyncTracker tracker = handler.getCurrentTracker();
        if (tracker == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(context + " no active tracker");
            }
        } else if (handler.isRefreshed(tracker)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(context + " tracker already complete");
            }
        } else if (!handler.prereqSatisfied(tracker)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(context + " waiting on a pre-req to complete");
            }
            result = SynchOutcome.WAITING_ON_PREREQ;
        } else {
            RefData container = handler.getExistingContainer();
            if (container == null) {
                log.severe(context + " container of type RefData does not exist");
                result = SynchOutcome.MISSING_CONTAINER;
            } else if (!ModelUtil.isExpired(handler.getExpiryTime(container))) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(context + " not expired");
                }
                handler.updateStatus(tracker, SyncTracker.SyncState.NOT_EXPIRED, null);
                result = SynchOutcome.NOT_EXPIRED;
            } else {
                result = SynchOutcome.PROCEED;
            }
        }
        return result;
    }

    public void storeSynchResults(final long time, final SyncTracker.SyncState requestStatus, final String statusDetail, final long nextExpiry, String msgInfo, List<RefCachedData> toStore, final RefSynchronizationHandler handler) throws IOException {
        String context = "[refData]";
        CommitBlock<IOException> commitBlock = new CommitBlock<IOException>(){
            RefSyncTracker tracker;
            RefData container;
            List<RefCachedData> els;

            @Override
            public void setParams(RefSyncTracker tracker, RefData container, List<RefCachedData> elementSet) {
                this.tracker = tracker;
                this.container = container;
                this.els = elementSet;
            }

            public IOException run() {
                log.fine("Processing " + this.els.size() + " updates");
                long start = OrbitalProperties.getCurrentTime();
                for (RefCachedData i : this.els) {
                    if (handler.commit(time, this.tracker, this.container, i)) continue;
                    return new IOException("[refData] DataCommitter returned false while committing: " + i);
                }
                long end = OrbitalProperties.getCurrentTime();
                if (log.isLoggable(Level.FINE)) {
                    long delay = end - start;
                    double rate = (double)delay / (double)this.els.size();
                    log.fine("Process rate = " + rate + " milliseconds/update");
                }
                return null;
            }
        };
        ConnectionFactory.RunInTransaction<TrackTriple> setup = new ConnectionFactory.RunInTransaction<TrackTriple>(){

            public TrackTriple run() {
                RefSyncTracker tracker = handler.getCurrentTracker();
                if (tracker == null) {
                    log.fine("[refData] no active tracker");
                    return null;
                }
                log.fine("tracker: " + tracker);
                if (handler.isRefreshed(tracker)) {
                    log.fine("[refData] tracker already complete");
                    return null;
                }
                RefData container = handler.getExistingContainer();
                if (container == null) {
                    log.severe("[refData] container of type RefData does not exist");
                    return new TrackTriple(null, null, new IOException("[refData] container of type RefData does not exist"));
                }
                handler.updateStatus(tracker, requestStatus, statusDetail);
                handler.updateExpiry(container, nextExpiry);
                return new TrackTriple(tracker, container, null);
            }
        };
        TrackTriple getSetup = null;
        try {
            getSetup = (TrackTriple)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)setup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
        if (getSetup == null) {
            log.fine("Completed storeSyncResultsProcessing");
            return;
        }
        if (getSetup.getException() != null) {
            throw getSetup.getException();
        }
        RefSyncTracker tracker = getSetup.getTracker();
        RefData container = getSetup.getContainer();
        if (toStore != null && toStore.size() > 0) {
            log.fine("Processing " + toStore.size() + " total updates");
            int i = 0;
            int endIndex = Math.min(i + 200, toStore.size());
            while (i < toStore.size()) {
                commitBlock.setParams(tracker, container, toStore.subList(i, endIndex));
                IOException status = null;
                try {
                    status = (IOException)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)commitBlock);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "query error", e);
                }
                if (status != null) {
                    throw status;
                }
                i = endIndex;
                endIndex = Math.min(i + 200, toStore.size());
            }
        }
        log.fine("Completed storeSyncResultsProcessing");
    }

    public SyncStatus preSyncCheck(final String msgInfo, final RefSynchronizationHandler handler) {
        SyncStatus result = null;
        try {
            result = (SyncStatus)((Object)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SyncStatus>(){

                public SyncStatus run() {
                    SyncStatus result = SyncStatus.ERROR;
                    try {
                        switch (RefSynchronizerUtil.this.checkProceedWithSynch(msgInfo, handler)) {
                            case COMPLETE: 
                            case NOT_EXPIRED: {
                                result = SyncStatus.DONE;
                                break;
                            }
                            case MISSING_CONTAINER: {
                                log.severe("RefData was missing, scheduling to try again later");
                                break;
                            }
                            case WAITING_ON_PREREQ: {
                                log.fine("Pre-reqs not completed yet, rescheduling");
                                break;
                            }
                            case SYSTEM_ERROR: {
                                log.warning("Proceed checker failed with a system error, rescheduling");
                                break;
                            }
                            default: {
                                result = SyncStatus.CONTINUE;
                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        log.warning("IOError handling pre-sync check: " + e);
                        result = SyncStatus.ERROR;
                    }
                    catch (RuntimeException e) {
                        log.warning("Pre sync check failed: " + e);
                        result = SyncStatus.ERROR;
                    }
                    return result;
                }
            }));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
        return result;
    }

    private class TrackTriple {
        public RefSyncTracker tracker;
        public RefData container;
        public IOException e;

        public TrackTriple(RefSyncTracker tracker, RefData container, IOException e) {
            this.tracker = tracker;
            this.container = container;
            this.e = e;
        }

        public RefSyncTracker getTracker() {
            return this.tracker;
        }

        public RefData getContainer() {
            return this.container;
        }

        public IOException getException() {
            return this.e;
        }
    }

    private static interface CommitBlock<B>
    extends ConnectionFactory.RunInTransaction<B> {
        public void setParams(RefSyncTracker var1, RefData var2, List<RefCachedData> var3);
    }

    public static enum SynchOutcome {
        PROCEED,
        COMPLETE,
        WAITING_ON_PREREQ,
        MISSING_CONTAINER,
        NOT_EXPIRED,
        SYSTEM_ERROR;

    }

    public static enum SyncStatus {
        CONTINUE,
        DONE,
        ERROR;

    }
}

