/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import enterprises.orbital.base.OrbitalProperties;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ModelUtil {
    private static final ThreadLocal<DateFormat> dateFormat = OrbitalProperties.dateFormatFactory((OrbitalProperties.DateFormatGenerator)new OrbitalProperties.DateFormatGenerator(){

        public DateFormat generate() {
            SimpleDateFormat result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            result.setTimeZone(TimeZone.getTimeZone("UTC"));
            return result;
        }
    });

    public static boolean isExpired(long cachedUntil) {
        long now = OrbitalProperties.getCurrentTime();
        return cachedUntil < now;
    }

    public long expiresIn(long cachedUntil) {
        return Math.max(cachedUntil - OrbitalProperties.getCurrentTime(), 0L);
    }

    public static Date convertEpochToDate(long epochTime) {
        return new Date(epochTime);
    }

    public static String formatDate(Date asDate) {
        return dateFormat.get().format(asDate);
    }

    public static String formatDate(long epochTime) {
        return ModelUtil.formatDate(ModelUtil.convertEpochToDate(epochTime));
    }

    public static long dateNormalizer(long sourceDate) {
        return sourceDate <= 0L ? -1L : sourceDate;
    }

    public static long safeConvertDate(Date dt) {
        return dt == null ? -1L : ModelUtil.dateNormalizer(dt.getTime());
    }
}

