/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.map.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.map.MapJump;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.map.IJump;
import enterprises.orbital.evexmlapi.map.IMapAPI;
import enterprises.orbital.evexmlapi.map.IMapJump;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class MapJumpSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(MapJumpSync.class.getName());
    private static final MapJumpSync syncher = new MapJumpSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getMapJumpStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getMapJumpExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setMapJumpStatus(status);
        tracker.setMapJumpDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setMapJumpExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof MapJump) {
            MapJump api = (MapJump)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                MapJump existing = MapJump.get((long)time, (int)api.getSolarSystemID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IMapAPI)serverRequest).requestJumps();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        IMapJump jumpList = (IMapJump)data;
        HashSet<Integer> seenJumps = new HashSet<Integer>();
        for (IJump nextJump : jumpList.getJumps()) {
            updates.add((RefCachedData)new MapJump(nextJump.getSolarSystemID(), nextJump.getShipJumps()));
            seenJumps.add(nextJump.getSolarSystemID());
        }
        AttributeSelector ats = MapJumpSync.makeAtSelector(time);
        List nextBatch = MapJump.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextBatch.isEmpty()) {
            for (MapJump n : nextBatch) {
                if (seenJumps.contains(n.getSolarSystemID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextBatch = MapJump.accessQuery((long)((MapJump)nextBatch.get(nextBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "MapJump");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "MapJump", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "MapJump", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

