/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.eve.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.eve.RequiredSkill;
import enterprises.orbital.evekit.model.eve.SkillBonus;
import enterprises.orbital.evekit.model.eve.SkillGroup;
import enterprises.orbital.evekit.model.eve.SkillMember;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.eve.IBonus;
import enterprises.orbital.evexmlapi.eve.IEveAPI;
import enterprises.orbital.evexmlapi.eve.IRequiredSkill;
import enterprises.orbital.evexmlapi.eve.ISkillGroup;
import enterprises.orbital.evexmlapi.eve.ISkillMember;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class SkillTreeSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(SkillTreeSync.class.getName());
    private static final SkillTreeSync syncher = new SkillTreeSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getSkillTreeStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getSkillTreeExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setSkillTreeStatus(status);
        tracker.setSkillTreeDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setSkillTreeExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof RequiredSkill) {
            RequiredSkill api = (RequiredSkill)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                RequiredSkill existing = RequiredSkill.get((long)time, (int)api.getParentTypeID(), (int)api.getTypeID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof SkillBonus) {
            SkillBonus api = (SkillBonus)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                SkillBonus existing = SkillBonus.get((long)time, (int)api.getTypeID(), (String)api.getBonusType());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof SkillGroup) {
            SkillGroup api = (SkillGroup)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                SkillGroup existing = SkillGroup.get((long)time, (int)api.getGroupID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof SkillMember) {
            SkillMember api = (SkillMember)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                SkillMember existing = SkillMember.get((long)time, (int)api.getTypeID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IEveAPI)serverRequest).requestSkillTree();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        Collection skillTree = (Collection)data;
        HashSet<Integer> seenGroups = new HashSet<Integer>();
        HashSet<Integer> seenSkills = new HashSet<Integer>();
        HashMap seenBonusType = new HashMap();
        HashMap seenRequiredSkill = new HashMap();
        for (ISkillGroup nextGroup : skillTree) {
            if (!seenGroups.contains(nextGroup.getGroupID())) {
                seenGroups.add(nextGroup.getGroupID());
                updates.add((RefCachedData)new SkillGroup(nextGroup.getGroupID(), nextGroup.getGroupName()));
            }
            for (ISkillMember nextMember : nextGroup.getSkills()) {
                seenSkills.add(nextMember.getTypeID());
                updates.add((RefCachedData)new SkillMember(nextMember.getGroupID(), nextMember.getTypeID(), nextMember.getDescription(), nextMember.getRank(), nextMember.getRequiredPrimaryAttribute(), nextMember.getRequiredSecondaryAttribute(), nextMember.getTypeName(), nextMember.isPublished()));
                for (IRequiredSkill nextRequired : nextMember.getRequiredSkills()) {
                    if (!seenRequiredSkill.containsKey(nextMember.getTypeID())) {
                        seenRequiredSkill.put(nextMember.getTypeID(), new HashSet());
                    }
                    ((Set)seenRequiredSkill.get(nextMember.getTypeID())).add(nextRequired.getTypeID());
                    updates.add((RefCachedData)new RequiredSkill(nextMember.getTypeID(), nextRequired.getTypeID(), nextRequired.getLevel()));
                }
                for (IBonus nextBonus : nextMember.getBonuses()) {
                    if (!seenBonusType.containsKey(nextMember.getTypeID())) {
                        seenBonusType.put(nextMember.getTypeID(), new HashSet());
                    }
                    ((Set)seenBonusType.get(nextMember.getTypeID())).add(nextBonus.getBonusType());
                    updates.add((RefCachedData)new SkillBonus(nextMember.getTypeID(), nextBonus.getBonusType(), nextBonus.getBonusValue()));
                }
            }
        }
        AttributeSelector ats = SkillTreeSync.makeAtSelector(time);
        List nextGroupBatch = SkillGroup.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextGroupBatch.isEmpty()) {
            for (Object n : nextGroupBatch) {
                if (seenGroups.contains(n.getGroupID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextGroupBatch = SkillGroup.accessQuery((long)((SkillGroup)nextGroupBatch.get(nextGroupBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        List nextMemberBatch = SkillMember.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextMemberBatch.isEmpty()) {
            for (Object n : nextMemberBatch) {
                if (seenSkills.contains(n.getTypeID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextMemberBatch = SkillMember.accessQuery((long)((SkillMember)nextMemberBatch.get(nextMemberBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        List nextBonusBatch = SkillBonus.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextBonusBatch.isEmpty()) {
            for (SkillBonus n : nextBonusBatch) {
                if (seenBonusType.containsKey(n.getTypeID()) && ((Set)seenBonusType.get(n.getTypeID())).contains(n.getBonusType())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextBonusBatch = SkillBonus.accessQuery((long)((SkillBonus)nextBonusBatch.get(nextBonusBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        List nextRequiredBatch = RequiredSkill.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextRequiredBatch.isEmpty()) {
            for (RequiredSkill n : nextRequiredBatch) {
                if (seenRequiredSkill.containsKey(n.getParentTypeID()) && ((Set)seenRequiredSkill.get(n.getParentTypeID())).contains(n.getTypeID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextRequiredBatch = RequiredSkill.accessQuery((long)((RequiredSkill)nextRequiredBatch.get(nextRequiredBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "SkillTree");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "SkillTree", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "SkillTree", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

