/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.eve.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.eve.ConquerableStation;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.eve.IConquerableStation;
import enterprises.orbital.evexmlapi.eve.IEveAPI;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class ConquerableStationsSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(ConquerableStationsSync.class.getName());
    private static final ConquerableStationsSync syncher = new ConquerableStationsSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getConquerableStationsStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getConquerableStationsExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setConquerableStationsStatus(status);
        tracker.setConquerableStationsDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setConquerableStationsExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof ConquerableStation) {
            ConquerableStation api = (ConquerableStation)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                ConquerableStation existing = ConquerableStation.get((long)time, (long)api.getStationID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IEveAPI)serverRequest).requestConquerableStations();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        Collection stationList = (Collection)data;
        HashSet<Long> seenStations = new HashSet<Long>();
        for (IConquerableStation nextStation : stationList) {
            updates.add((RefCachedData)new ConquerableStation(nextStation.getCorporationID(), nextStation.getCorporationName(), nextStation.getSolarSystemID(), nextStation.getStationID(), nextStation.getStationName(), nextStation.getStationTypeID(), nextStation.getX(), nextStation.getY(), nextStation.getZ()));
            seenStations.add(nextStation.getStationID());
        }
        AttributeSelector ats = ConquerableStationsSync.makeAtSelector(time);
        List nextBatch = ConquerableStation.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextBatch.isEmpty()) {
            for (ConquerableStation n : nextBatch) {
                if (seenStations.contains(n.getStationID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextBatch = ConquerableStation.accessQuery((long)((ConquerableStation)nextBatch.get(nextBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "ConquerableStations");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "ConquerableStations", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "ConquerableStations", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

