/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.calls.sync;

import enterprises.orbital.evekit.model.AbstractRefSync;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.calls.Call;
import enterprises.orbital.evekit.model.calls.CallGroup;
import enterprises.orbital.evexmlapi.IResponse;
import enterprises.orbital.evexmlapi.api.IApiAPI;
import enterprises.orbital.evexmlapi.api.ICall;
import enterprises.orbital.evexmlapi.api.ICallGroup;
import enterprises.orbital.evexmlapi.api.ICallList;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class CallListSync
extends AbstractRefSync {
    protected static final Logger log = Logger.getLogger(CallListSync.class.getName());
    private static final CallListSync syncher = new CallListSync();

    @Override
    public boolean isRefreshed(RefSyncTracker tracker) {
        return tracker.getCallListStatus() != SyncTracker.SyncState.NOT_PROCESSED;
    }

    @Override
    public long getExpiryTime(RefData container) {
        return container.getCallListExpiry();
    }

    @Override
    public void updateStatus(RefSyncTracker tracker, SyncTracker.SyncState status, String detail) {
        tracker.setCallListStatus(status);
        tracker.setCallListDetail(detail);
        RefSyncTracker.updateTracker((RefSyncTracker)tracker);
    }

    @Override
    public void updateExpiry(RefData container, long expiry) {
        container.setCallListExpiry(expiry);
        RefCachedData.updateData((RefCachedData)container);
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        if (item instanceof Call) {
            Call api = (Call)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                Call existing = Call.get((long)time, (String)api.getType(), (String)api.getName());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else if (item instanceof CallGroup) {
            CallGroup api = (CallGroup)item;
            if (api.getLifeStart() != 0L) {
                super.commit(time, tracker, container, (RefCachedData)api);
            } else {
                CallGroup existing = CallGroup.get((long)time, (long)api.getGroupID());
                if (existing != null) {
                    if (!existing.equivalent((RefCachedData)api)) {
                        existing.evolve((RefCachedData)api, time);
                        super.commit(time, tracker, container, (RefCachedData)existing);
                        super.commit(time, tracker, container, (RefCachedData)api);
                    }
                } else {
                    api.setup(time);
                    super.commit(time, tracker, container, (RefCachedData)api);
                }
            }
        } else assert (false);
        return true;
    }

    @Override
    protected Object getServerData(IResponse serverRequest) throws IOException {
        return ((IApiAPI)serverRequest).requestCallList();
    }

    @Override
    protected long processServerData(long time, IResponse serverRequest, Object data, List<RefCachedData> updates) throws IOException {
        ICallList callList = (ICallList)data;
        HashSet<Long> seenGroups = new HashSet<Long>();
        for (ICallGroup nextGroup : callList.getCallGroups()) {
            updates.add((RefCachedData)new CallGroup(nextGroup.getGroupID(), nextGroup.getName(), nextGroup.getDescription()));
            seenGroups.add(nextGroup.getGroupID());
        }
        AttributeSelector ats = CallListSync.makeAtSelector(time);
        List nextBatch = CallGroup.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextBatch.isEmpty()) {
            for (CallGroup n : nextBatch) {
                if (seenGroups.contains(n.getGroupID())) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextBatch = CallGroup.accessQuery((long)((CallGroup)nextBatch.get(nextBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        HashSet<String> seenCalls = new HashSet<String>();
        for (ICall nextCall : callList.getCalls()) {
            updates.add((RefCachedData)new Call(nextCall.getAccessMask(), nextCall.getType(), nextCall.getName(), nextCall.getGroupID(), nextCall.getDescription()));
            String key = nextCall.getType() + "!" + nextCall.getName();
            seenCalls.add(key);
        }
        List nextCallBatch = Call.accessQuery((long)-1L, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        while (!nextCallBatch.isEmpty()) {
            for (Call n : nextCallBatch) {
                String key = n.getType() + "!" + n.getName();
                if (seenCalls.contains(key)) continue;
                n.evolve(null, time);
                updates.add((RefCachedData)n);
            }
            nextCallBatch = Call.accessQuery((long)((Call)nextCallBatch.get(nextCallBatch.size() - 1)).getCid(), (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR, (AttributeSelector)ANY_SELECTOR);
        }
        return serverRequest.getCachedUntil().getTime();
    }

    public static RefSynchronizerUtil.SyncStatus sync(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest) {
        return syncher.syncData(time, syncUtil, serverRequest, "CallList");
    }

    public static RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "CallList", SyncTracker.SyncState.SYNC_ERROR);
    }

    public static RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
        return syncher.excludeState(syncUtil, "CallList", SyncTracker.SyncState.NOT_ALLOWED);
    }
}

