/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.base.PersistentProperty;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.SynchronizationState;
import enterprises.orbital.evekit.model.calls.sync.CallListSync;
import enterprises.orbital.evekit.model.eve.sync.AllianceSync;
import enterprises.orbital.evekit.model.eve.sync.ConquerableStationsSync;
import enterprises.orbital.evekit.model.eve.sync.ErrorsSync;
import enterprises.orbital.evekit.model.eve.sync.FacWarStatsSync;
import enterprises.orbital.evekit.model.eve.sync.FacWarTopStatsSync;
import enterprises.orbital.evekit.model.eve.sync.RefTypeSync;
import enterprises.orbital.evekit.model.eve.sync.SkillTreeSync;
import enterprises.orbital.evekit.model.map.sync.FacWarSystemsSync;
import enterprises.orbital.evekit.model.map.sync.MapJumpSync;
import enterprises.orbital.evekit.model.map.sync.MapKillSync;
import enterprises.orbital.evekit.model.map.sync.SovereigntySync;
import enterprises.orbital.evekit.model.server.sync.ServerStatusSync;
import enterprises.orbital.evexmlapi.EveXmlApiAdapter;
import enterprises.orbital.evexmlapi.EveXmlApiConfig;
import enterprises.orbital.evexmlapi.IEveXmlApi;
import enterprises.orbital.evexmlapi.IResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RefDataSynchronizer {
    protected static final Logger log = Logger.getLogger(RefDataSynchronizer.class.getName());
    public static final String PROP_SKIP_SYNC = "enterprises.orbital.evekit.ref.skip_sync";
    public static final String PROP_SYNC_ATTEMPT_SEPARATION = "enterprises.orbital.evekit.ref.sync_attempt_separation";
    public static final String PROP_SYNC_TERM_DELAY = "enterprises.orbital.evekit.ref.sync_terminate_delay";
    public static final String PROP_CONNECT_TIMEOUT = "enterprises.orbital.evekit.timeout.connect";
    public static final String PROP_READ_TIMEOUT = "enterprises.orbital.evekit.timeout.read";
    public static final String PROP_SITE_AGENT = "enterprises.orbital.evekit.site_agent";
    public static final String PROP_XML_API_URL = "enterprises.orbital.evekit.api_server_url";
    public static final Map<SynchronizationState, RefStateHandler> supportedFeatures = new HashMap<SynchronizationState, RefStateHandler>();

    protected static Set<SynchronizationState> getExcludedStates() {
        String[] excludedStates = PersistentProperty.getPropertyWithFallback((String)PROP_SKIP_SYNC, (String)"").split("\\|");
        HashSet<SynchronizationState> excluded = new HashSet<SynchronizationState>();
        for (String next : excludedStates) {
            try {
                if (next.isEmpty()) continue;
                SynchronizationState val = SynchronizationState.valueOf((String)next);
                switch (val) {
                    case SYNC_REF_START: 
                    case SYNC_REF_END: {
                        log.warning("Not allowed to exclude start or stop states, ignoring: " + val);
                        break;
                    }
                    default: {
                        excluded.add(val);
                    }
                }
            }
            catch (Exception e) {
                log.warning("Error handling excluded state name: " + next + ", ignoring with error: " + e);
            }
        }
        return excluded;
    }

    public static IEveXmlApi getApiHandle() throws URISyntaxException {
        String agentValue = OrbitalProperties.getGlobalProperty((String)PROP_SITE_AGENT, (String)"unknown-agent");
        int connectTimeout = (int)OrbitalProperties.getLongGlobalProperty((String)PROP_CONNECT_TIMEOUT, (long)60000L);
        int readTimeout = (int)OrbitalProperties.getLongGlobalProperty((String)PROP_READ_TIMEOUT, (long)60000L);
        String serverURI = OrbitalProperties.getGlobalProperty((String)PROP_XML_API_URL, (String)"https://api.eveonline.com");
        return new EveXmlApiAdapter(EveXmlApiConfig.get().serverURI(serverURI).agent(agentValue).connectTimeout(connectTimeout).readTimeout(readTimeout));
    }

    protected static boolean verifyTrackerNotStuck() {
        long delaySinceStart;
        long terminateDelay = PersistentProperty.getLongPropertyWithFallback((String)PROP_SYNC_TERM_DELAY, (long)Long.MAX_VALUE);
        long now = OrbitalProperties.getCurrentTime();
        RefSyncTracker next = RefSyncTracker.getUnfinishedTracker();
        if (next != null && (delaySinceStart = now - next.getSyncStart()) > terminateDelay) {
            log.fine("Forcing tracker to terminate due to delay: " + next);
            RefSyncTracker.finishTracker((RefSyncTracker)next);
            return false;
        }
        return true;
    }

    protected static boolean verifyTrackerSeparation() {
        boolean sync;
        long spacing = PersistentProperty.getLongPropertyWithFallback((String)PROP_SYNC_ATTEMPT_SEPARATION, (long)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
        RefSyncTracker tracker = RefSyncTracker.getLatestFinishedTracker();
        long now = OrbitalProperties.getCurrentTime();
        long earliestStart = tracker != null ? tracker.getSyncEnd() + spacing : now;
        boolean bl = sync = earliestStart <= now;
        if (!sync) {
            log.fine("Insufficient tracker separation, skipping");
        }
        return sync;
    }

    public void synchronize() throws IOException, URISyntaxException {
        log.fine("Starting sync");
        IEveXmlApi apiHandle = RefDataSynchronizer.getApiHandle();
        if (!RefDataSynchronizer.verifyTrackerNotStuck()) {
            return;
        }
        if (!RefDataSynchronizer.verifyTrackerSeparation()) {
            return;
        }
        RefSyncTracker tracker = RefSyncTracker.createOrGetUnfinishedTracker();
        if (tracker.getSyncStart() <= 0L) {
            tracker.setSyncStart(OrbitalProperties.getCurrentTime());
            tracker = RefSyncTracker.updateTracker((RefSyncTracker)tracker);
        }
        RefData.getOrCreateRefData();
        RefSynchronizerUtil syncUtil = new RefSynchronizerUtil();
        Set<SynchronizationState> excluded = RefDataSynchronizer.getExcludedStates();
        long syncTime = tracker.getSyncStart();
        SynchronizationState state = tracker.trackerComplete(supportedFeatures.keySet());
        RefSynchronizerUtil.SyncStatus lastStatus = RefSynchronizerUtil.SyncStatus.DONE;
        do {
            block9: {
                try {
                    RefStateHandler handler = supportedFeatures.get(state);
                    if (handler != null) {
                        lastStatus = excluded.contains(state) ? handler.exclude(syncUtil) : handler.sync(syncTime, syncUtil, apiHandle);
                    } else {
                        log.warning("No handler for state " + state + ".  This sync will eventually time out if this state is expected to be handled!");
                        lastStatus = RefSynchronizerUtil.SyncStatus.DONE;
                    }
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Current step " + state + " will be marked as failed and not retried", e);
                    lastStatus = RefSynchronizerUtil.SyncStatus.DONE;
                    tracker = RefSyncTracker.getUnfinishedTracker();
                    if (tracker == null) break block9;
                    tracker.setState(state, SyncTracker.SyncState.SYNC_ERROR, "Internal error.  Contact the admin for more information");
                    RefSyncTracker.updateTracker((RefSyncTracker)tracker);
                }
            }
            tracker = RefSyncTracker.getUnfinishedTracker();
            SynchronizationState synchronizationState = state = tracker == null ? null : tracker.trackerComplete(supportedFeatures.keySet());
        } while (state != null && lastStatus == RefSynchronizerUtil.SyncStatus.DONE);
        if (tracker != null && tracker.trackerComplete(supportedFeatures.keySet()) == null) {
            log.fine("Tracker done, marking as finished");
            RefSyncTracker.finishTracker((RefSyncTracker)tracker);
        }
    }

    static {
        supportedFeatures.put(SynchronizationState.SYNC_REF_SERVERSTATUS, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return ServerStatusSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return ServerStatusSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return ServerStatusSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getServerAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_CALLS_LIST, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return CallListSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return CallListSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return CallListSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getApiAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_ALLIANCES, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return AllianceSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return AllianceSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return AllianceSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getEveAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_CONQUERABLE, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return ConquerableStationsSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return ConquerableStationsSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return ConquerableStationsSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getEveAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_ERRORLIST, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return ErrorsSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return ErrorsSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return ErrorsSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getEveAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_FACWARSTATS, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return FacWarStatsSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return FacWarStatsSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return FacWarStatsSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getEveAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_FACWARTOPSTATS, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return FacWarTopStatsSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return FacWarTopStatsSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return FacWarTopStatsSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getEveAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_REFTYPES, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return RefTypeSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return RefTypeSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return RefTypeSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getEveAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_SKILLTREE, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return SkillTreeSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return SkillTreeSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return SkillTreeSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getEveAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_FACWARSYSTEMS, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return FacWarSystemsSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return FacWarSystemsSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return FacWarSystemsSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getMapAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_MAPJUMPS, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return MapJumpSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return MapJumpSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return MapJumpSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getMapAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_MAPKILLS, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return MapKillSync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return MapKillSync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return MapKillSync.sync(syncTime, syncUtil, (IResponse)apiHandle.getMapAPIService());
            }
        });
        supportedFeatures.put(SynchronizationState.SYNC_REF_SOVEREIGNTY, new RefStateHandler(){

            @Override
            public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil syncUtil) {
                return SovereigntySync.exclude(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil syncUtil) {
                return SovereigntySync.notAllowed(syncUtil);
            }

            @Override
            public RefSynchronizerUtil.SyncStatus sync(long syncTime, RefSynchronizerUtil syncUtil, IEveXmlApi apiHandle) {
                return SovereigntySync.sync(syncTime, syncUtil, (IResponse)apiHandle.getMapAPIService());
            }
        });
    }

    public static interface RefStateHandler {
        public RefSynchronizerUtil.SyncStatus exclude(RefSynchronizerUtil var1);

        public RefSynchronizerUtil.SyncStatus notAllowed(RefSynchronizerUtil var1);

        public RefSynchronizerUtil.SyncStatus sync(long var1, RefSynchronizerUtil var3, IEveXmlApi var4);
    }
}

