/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.RefData;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.RefSynchronizationHandler;
import enterprises.orbital.evekit.model.RefSynchronizerUtil;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evexmlapi.IResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRefSync
implements RefSynchronizationHandler {
    private static final Logger log = Logger.getLogger(AbstractRefSync.class.getName());
    protected static final AttributeSelector ANY_SELECTOR = new AttributeSelector("{ any: true }");

    protected static AttributeSelector makeAtSelector(long time) {
        return new AttributeSelector("{values: [" + time + "]}");
    }

    public static boolean StringChanged(String a, String b) {
        return !String.valueOf(a).equals(String.valueOf(b));
    }

    @Override
    public RefSyncTracker getCurrentTracker() {
        return RefSyncTracker.getUnfinishedTracker();
    }

    @Override
    public RefData getExistingContainer() {
        return RefData.getRefData();
    }

    @Override
    public boolean prereqSatisfied(RefSyncTracker tracker) {
        return true;
    }

    @Override
    public boolean commit(long time, RefSyncTracker tracker, RefData container, RefCachedData item) {
        return RefCachedData.updateData((RefCachedData)item) != null;
    }

    protected abstract Object getServerData(IResponse var1) throws IOException;

    protected static SyncTracker.SyncState handleServerError(IResponse serverRequest, StringBuilder errorDetail) {
        switch (serverRequest.getErrorCode()) {
            case 125: 
            case 220: 
            case 221: 
            case 222: {
                errorDetail.append("Warning ").append(serverRequest.getErrorCode()).append(": ").append(serverRequest.getErrorString());
                return SyncTracker.SyncState.SYNC_WARNING;
            }
        }
        errorDetail.append("Error ").append(serverRequest.getErrorCode()).append(": ").append(serverRequest.getErrorString());
        return SyncTracker.SyncState.SYNC_ERROR;
    }

    protected abstract long processServerData(long var1, IResponse var3, Object var4, List<RefCachedData> var5) throws IOException;

    public RefSynchronizerUtil.SyncStatus syncData(long time, RefSynchronizerUtil syncUtil, IResponse serverRequest, String description) {
        try {
            RefSynchronizerUtil.SyncStatus preCheck = syncUtil.preSyncCheck(description, this);
            if (preCheck != RefSynchronizerUtil.SyncStatus.CONTINUE) {
                return preCheck;
            }
            log.fine("Starting refresh request for " + description);
            SyncTracker.SyncState status = SyncTracker.SyncState.UPDATED;
            String errorDetail = null;
            long nextExpiry = -1L;
            ArrayList<RefCachedData> updateList = new ArrayList<RefCachedData>();
            try {
                Object serverData = this.getServerData(serverRequest);
                if (serverRequest.isError()) {
                    StringBuilder errStr = new StringBuilder();
                    status = AbstractRefSync.handleServerError(serverRequest, errStr);
                    errorDetail = errStr.toString();
                    if (status == SyncTracker.SyncState.SYNC_ERROR) {
                        log.warning("request failed: " + errorDetail);
                    }
                } else {
                    nextExpiry = this.processServerData(time, serverRequest, serverData, updateList);
                }
            }
            catch (IOException e) {
                status = SyncTracker.SyncState.SYNC_ERROR;
                errorDetail = "request failed with IO error";
                log.log(Level.WARNING, "request failed with error", e);
            }
            log.fine("Completed refresh request for " + description);
            syncUtil.storeSynchResults(time, status, errorDetail, nextExpiry, description, updateList, this);
            return RefSynchronizerUtil.SyncStatus.DONE;
        }
        catch (IOException e) {
            log.warning("store failed with error " + e);
            return RefSynchronizerUtil.SyncStatus.ERROR;
        }
    }

    protected RefSynchronizerUtil.SyncStatus excludeState(RefSynchronizerUtil syncUtil, String description, SyncTracker.SyncState state) {
        try {
            RefSynchronizerUtil.SyncStatus preCheck = syncUtil.preSyncCheck(description, this);
            if (preCheck != RefSynchronizerUtil.SyncStatus.CONTINUE) {
                return preCheck;
            }
            log.fine("Exluding synchronization for " + description);
            SyncTracker.SyncState status = state;
            String errorDetail = "";
            switch (status) {
                case NOT_ALLOWED: {
                    errorDetail = "API key for this account does not allow synchronization of this data.  Contact the site admin if you think this is an error.";
                    break;
                }
                default: {
                    errorDetail = "Synchronization skipped due to admin exclusion.  Contact the site admin for more info.";
                }
            }
            syncUtil.storeSynchResults(0L, status, errorDetail, -1L, description, null, this);
            return RefSynchronizerUtil.SyncStatus.DONE;
        }
        catch (IOException e) {
            log.warning("store failed with error " + e);
            return RefSynchronizerUtil.SyncStatus.ERROR;
        }
    }
}

