/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.sov;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_sov_map")
@NamedQueries(value={@NamedQuery(name="SovereigntyMap.get", query="SELECT c FROM SovereigntyMap c WHERE c.systemID = :sid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class SovereigntyMap
extends RefCachedData {
    private static final Logger log = Logger.getLogger(SovereigntyMap.class.getName());
    private int allianceID;
    private int corporationID;
    private int factionID;
    private int systemID;

    protected SovereigntyMap() {
    }

    public SovereigntyMap(int allianceID, int corporationID, int factionID, int systemID) {
        this.allianceID = allianceID;
        this.corporationID = corporationID;
        this.factionID = factionID;
        this.systemID = systemID;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof SovereigntyMap)) {
            return false;
        }
        SovereigntyMap other = (SovereigntyMap)sup;
        return this.allianceID == other.allianceID && this.corporationID == other.corporationID && this.factionID == other.factionID && this.systemID == other.systemID;
    }

    public long getAllianceID() {
        return this.allianceID;
    }

    public long getCorporationID() {
        return this.corporationID;
    }

    public long getFactionID() {
        return this.factionID;
    }

    public int getSystemID() {
        return this.systemID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SovereigntyMap that = (SovereigntyMap)o;
        return this.allianceID == that.allianceID && this.corporationID == that.corporationID && this.factionID == that.factionID && this.systemID == that.systemID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.allianceID, this.corporationID, this.factionID, this.systemID);
    }

    @Override
    public String toString() {
        return "SovereigntyMap{allianceID=" + this.allianceID + ", corporationID=" + this.corporationID + ", factionID=" + this.factionID + ", systemID=" + this.systemID + '}';
    }

    public static SovereigntyMap get(long time, int systemID) throws IOException {
        try {
            return (SovereigntyMap)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("SovereigntyMap.get", SovereigntyMap.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("sid", (Object)systemID);
                try {
                    return (SovereigntyMap)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<SovereigntyMap> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector allianceID, AttributeSelector corporationID, AttributeSelector factionID, AttributeSelector systemID) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM SovereigntyMap c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"allianceID", (AttributeSelector)allianceID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"corporationID", (AttributeSelector)corporationID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"factionID", (AttributeSelector)factionID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"systemID", (AttributeSelector)systemID);
                SovereigntyMap.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), SovereigntyMap.class);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

