/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.sov;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_sov_campaign_participant")
@NamedQueries(value={@NamedQuery(name="SovereigntyCampaignParticipant.get", query="SELECT c FROM SovereigntyCampaignParticipant c WHERE c.campaignID = :campaignid AND c.allianceID = :allianceid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class SovereigntyCampaignParticipant
extends RefCachedData {
    private static final Logger log = Logger.getLogger(SovereigntyCampaignParticipant.class.getName());
    private int campaignID;
    private int allianceID;
    private float score;

    protected SovereigntyCampaignParticipant() {
    }

    public SovereigntyCampaignParticipant(int campaignID, int allianceID, float score) {
        this.campaignID = campaignID;
        this.allianceID = allianceID;
        this.score = score;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof SovereigntyCampaignParticipant)) {
            return false;
        }
        SovereigntyCampaignParticipant other = (SovereigntyCampaignParticipant)sup;
        return this.campaignID == other.campaignID && this.allianceID == other.allianceID && this.score == other.score;
    }

    public int getCampaignID() {
        return this.campaignID;
    }

    public int getAllianceID() {
        return this.allianceID;
    }

    public float getScore() {
        return this.score;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SovereigntyCampaignParticipant that = (SovereigntyCampaignParticipant)o;
        return this.campaignID == that.campaignID && this.allianceID == that.allianceID && Float.compare(that.score, this.score) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.campaignID, this.allianceID, Float.valueOf(this.score));
    }

    @Override
    public String toString() {
        return "SovereigntyCampaignParticipant{campaignID=" + this.campaignID + ", allianceID=" + this.allianceID + ", score=" + this.score + '}';
    }

    public static SovereigntyCampaignParticipant get(long time, int campaignID, int allianceID) throws IOException {
        try {
            return (SovereigntyCampaignParticipant)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("SovereigntyCampaignParticipant.get", SovereigntyCampaignParticipant.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("campaignid", (Object)campaignID);
                getter.setParameter("allianceid", (Object)allianceID);
                try {
                    return (SovereigntyCampaignParticipant)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<SovereigntyCampaignParticipant> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector campaignID, AttributeSelector allianceID, AttributeSelector score) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM SovereigntyCampaignParticipant c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"campaignID", (AttributeSelector)campaignID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"allianceID", (AttributeSelector)allianceID);
                AttributeSelector.addFloatSelector((StringBuilder)qs, (String)"c", (String)"score", (AttributeSelector)score);
                SovereigntyCampaignParticipant.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), SovereigntyCampaignParticipant.class);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

