/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.sov;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_sov_campaign")
@NamedQueries(value={@NamedQuery(name="SovereigntyCampaign.get", query="SELECT c FROM SovereigntyCampaign c WHERE c.campaignID = :campaignid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class SovereigntyCampaign
extends RefCachedData {
    private static final Logger log = Logger.getLogger(SovereigntyCampaign.class.getName());
    private int campaignID;
    private long structureID;
    private int systemID;
    private int constellationID;
    private String eventType;
    private long startTime;
    private int defenderID;
    private float defenderScore;
    private float attackersScore;
    @Transient
    @ApiModelProperty(value="Start Time Date")
    @JsonProperty(value="startTimeDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date startTimeDate;

    protected SovereigntyCampaign() {
    }

    public SovereigntyCampaign(int campaignID, long structureID, int systemID, int constellationID, String eventType, long startTime, int defenderID, float defenderScore, float attackersScore) {
        this.campaignID = campaignID;
        this.structureID = structureID;
        this.systemID = systemID;
        this.constellationID = constellationID;
        this.eventType = eventType;
        this.startTime = startTime;
        this.defenderID = defenderID;
        this.defenderScore = defenderScore;
        this.attackersScore = attackersScore;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
        this.startTimeDate = this.assignDateField(this.startTime);
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof SovereigntyCampaign)) {
            return false;
        }
        SovereigntyCampaign other = (SovereigntyCampaign)sup;
        return this.campaignID == other.campaignID && this.structureID == other.structureID && this.systemID == other.systemID && this.constellationID == other.constellationID && SovereigntyCampaign.nullSafeObjectCompare(this.eventType, other.eventType) && this.startTime == other.startTime && this.defenderID == other.defenderID && this.defenderScore == other.defenderScore && this.attackersScore == other.attackersScore;
    }

    public int getCampaignID() {
        return this.campaignID;
    }

    public long getStructureID() {
        return this.structureID;
    }

    public int getSystemID() {
        return this.systemID;
    }

    public int getConstellationID() {
        return this.constellationID;
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getDefenderID() {
        return this.defenderID;
    }

    public float getDefenderScore() {
        return this.defenderScore;
    }

    public float getAttackersScore() {
        return this.attackersScore;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SovereigntyCampaign that = (SovereigntyCampaign)o;
        return this.campaignID == that.campaignID && this.structureID == that.structureID && this.systemID == that.systemID && this.constellationID == that.constellationID && this.startTime == that.startTime && this.defenderID == that.defenderID && Float.compare(that.defenderScore, this.defenderScore) == 0 && Float.compare(that.attackersScore, this.attackersScore) == 0 && Objects.equals(this.eventType, that.eventType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.campaignID, this.structureID, this.systemID, this.constellationID, this.eventType, this.startTime, this.defenderID, Float.valueOf(this.defenderScore), Float.valueOf(this.attackersScore));
    }

    @Override
    public String toString() {
        return "SovereigntyCampaign{campaignID=" + this.campaignID + ", structureID=" + this.structureID + ", systemID=" + this.systemID + ", constellationID=" + this.constellationID + ", eventType='" + this.eventType + '\'' + ", startTime=" + this.startTime + ", defenderID=" + this.defenderID + ", defenderScore=" + this.defenderScore + ", attackersScore=" + this.attackersScore + ", startTimeDate=" + this.startTimeDate + '}';
    }

    public static SovereigntyCampaign get(long time, int campaignID) throws IOException {
        try {
            return (SovereigntyCampaign)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("SovereigntyCampaign.get", SovereigntyCampaign.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("campaignid", (Object)campaignID);
                try {
                    return (SovereigntyCampaign)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<SovereigntyCampaign> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector campaignID, AttributeSelector structureID, AttributeSelector systemID, AttributeSelector constellationID, AttributeSelector eventType, AttributeSelector startTime, AttributeSelector defenderID, AttributeSelector defenderScore, AttributeSelector attackersScore) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM SovereigntyCampaign c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"campaignID", (AttributeSelector)campaignID);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"structureID", (AttributeSelector)structureID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"systemID", (AttributeSelector)systemID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"constellationID", (AttributeSelector)constellationID);
                AttributeSelector.addStringSelector((StringBuilder)qs, (String)"c", (String)"eventType", (AttributeSelector)eventType, (AttributeParameters)p);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"startTime", (AttributeSelector)startTime);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"defenderID", (AttributeSelector)defenderID);
                AttributeSelector.addFloatSelector((StringBuilder)qs, (String)"c", (String)"defenderScore", (AttributeSelector)defenderScore);
                AttributeSelector.addFloatSelector((StringBuilder)qs, (String)"c", (String)"attackersScore", (AttributeSelector)attackersScore);
                SovereigntyCampaign.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), SovereigntyCampaign.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

