/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.faction;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_map_facwarsystem")
@NamedQueries(value={@NamedQuery(name="FactionWarSystem.get", query="SELECT c FROM FactionWarSystem c WHERE c.solarSystemID = :sid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class FactionWarSystem
extends RefCachedData {
    private static final Logger log = Logger.getLogger(FactionWarSystem.class.getName());
    private int occupyingFactionID;
    private int owningFactionID;
    private int solarSystemID;
    private int victoryPoints;
    private int victoryPointsThreshold;
    private boolean contested;

    protected FactionWarSystem() {
    }

    public FactionWarSystem(int occupyingFactionID, int owningFactionID, int solarSystemID, int victoryPoints, int victoryPointsThreshold, boolean contested) {
        this.occupyingFactionID = occupyingFactionID;
        this.owningFactionID = owningFactionID;
        this.solarSystemID = solarSystemID;
        this.victoryPoints = victoryPoints;
        this.victoryPointsThreshold = victoryPointsThreshold;
        this.contested = contested;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof FactionWarSystem)) {
            return false;
        }
        FactionWarSystem other = (FactionWarSystem)sup;
        return this.occupyingFactionID == other.occupyingFactionID && this.owningFactionID == other.owningFactionID && this.solarSystemID == other.solarSystemID && this.victoryPoints == other.victoryPoints && this.victoryPointsThreshold == other.victoryPointsThreshold && this.contested == other.contested;
    }

    public int getOccupyingFactionID() {
        return this.occupyingFactionID;
    }

    public int getOwningFactionID() {
        return this.owningFactionID;
    }

    public int getSolarSystemID() {
        return this.solarSystemID;
    }

    public int getVictoryPoints() {
        return this.victoryPoints;
    }

    public int getVictoryPointsThreshold() {
        return this.victoryPointsThreshold;
    }

    public boolean isContested() {
        return this.contested;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FactionWarSystem that = (FactionWarSystem)o;
        return this.occupyingFactionID == that.occupyingFactionID && this.owningFactionID == that.owningFactionID && this.solarSystemID == that.solarSystemID && this.victoryPoints == that.victoryPoints && this.victoryPointsThreshold == that.victoryPointsThreshold && this.contested == that.contested;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.occupyingFactionID, this.owningFactionID, this.solarSystemID, this.victoryPoints, this.victoryPointsThreshold, this.contested);
    }

    @Override
    public String toString() {
        return "FactionWarSystem{occupyingFactionID=" + this.occupyingFactionID + ", owningFactionID=" + this.owningFactionID + ", solarSystemID=" + this.solarSystemID + ", victoryPoints=" + this.victoryPoints + ", victoryPointsThreshold=" + this.victoryPointsThreshold + ", contested=" + this.contested + '}';
    }

    public static FactionWarSystem get(long time, int solarSystemID) throws IOException {
        try {
            return (FactionWarSystem)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("FactionWarSystem.get", FactionWarSystem.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("sid", (Object)solarSystemID);
                try {
                    return (FactionWarSystem)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<FactionWarSystem> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector occupyingFactionID, AttributeSelector owningFactionID, AttributeSelector solarSystemID, AttributeSelector victoryPoints, AttributeSelector victoryPointsThreshold, AttributeSelector contested) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM FactionWarSystem c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"occupyingFactionID", (AttributeSelector)occupyingFactionID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"owningFactionID", (AttributeSelector)owningFactionID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"solarSystemID", (AttributeSelector)solarSystemID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"victoryPoints", (AttributeSelector)victoryPoints);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"victoryPointsThreshold", (AttributeSelector)victoryPointsThreshold);
                AttributeSelector.addBooleanSelector((StringBuilder)qs, (String)"c", (String)"contested", (AttributeSelector)contested);
                FactionWarSystem.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), FactionWarSystem.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

